/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.render;

import com.jgoodies.forms.factories.Borders;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.transfer.Download;
import de.dal33t.powerfolder.transfer.Transfer;
import de.dal33t.powerfolder.transfer.TransferProblem;
import de.dal33t.powerfolder.transfer.Upload;
import de.dal33t.powerfolder.ui.util.ColorUtil;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.EstimatedTime;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.TransferCounter;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.util.Date;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class UploadTableCellRenderer
extends DefaultTableCellRenderer {
    private Controller controller;
    private JProgressBar bar;

    public UploadTableCellRenderer(Controller controller) {
        this.controller = controller;
        this.bar = new JProgressBar();
        this.bar.setBorderPainted(false);
        this.bar.setBorder(Borders.EMPTY_BORDER);
        this.bar.setStringPainted(true);
        UIUtil.addUIChangeTask(new Runnable(){

            @Override
            public void run() {
                UploadTableCellRenderer.this.bar.updateUI();
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object instanceof Transfer) {
            Transfer transfer = (Transfer)object;
            TransferCounter transferCounter = transfer.getCounter();
            this.bar.setValue((int)(Math.max(0.0, transfer.getStateProgress()) * 100.0));
            if (object instanceof Download) {
                Download download = (Download)transfer;
                if (download.getTransferProblem() != null && UploadTableCellRenderer.shouldShowProblem(download.getTransferProblem())) {
                    TransferProblem transferProblem = download.getTransferProblem();
                    String string = download.getProblemInformation();
                    if (string == null) {
                        this.bar.setString(Translation.get(transferProblem.getTranslationId()));
                    } else {
                        this.bar.setString(Translation.get(transferProblem.getTranslationId(), string));
                    }
                } else {
                    Transfer.TransferState transferState = download.getTransferState();
                    if (transferState == null) {
                        transferState = Transfer.TransferState.NONE;
                    }
                    switch (transferState) {
                        case MATCHING: 
                        case VERIFYING: 
                        case FILERECORD_REQUEST: 
                        case COPYING: {
                            this.bar.setString(Translation.get(transferState.getTranslationId()));
                            break;
                        }
                        case DOWNLOADING: {
                            EstimatedTime estimatedTime = new EstimatedTime(download.getDownloadManager().getCounter().calculateEstimatedMillisToCompletion(), !download.isCompleted() && download.isStarted());
                            String string = Translation.get("transfers.kbs", Format.formatDecimal(transferCounter.calculateCurrentKBS()));
                            String string2 = (String)(estimatedTime.isActive() ? estimatedTime.toString() + " - " : "") + string;
                            this.bar.setString(string2);
                            break;
                        }
                        default: {
                            if (download.isCompleted()) {
                                Date date = download.getCompletedDate();
                                String string = date != null ? Format.formatDateShort(date, true) : "";
                                this.bar.setString(Translation.get("transfers.completed", string));
                                break;
                            }
                            if (download.isQueued()) {
                                this.bar.setString(Translation.get("transfers.queued"));
                                break;
                            }
                            if (download.isPending()) {
                                this.bar.setString(Translation.get("transfers.pending"));
                                break;
                            }
                            this.bar.setString(Translation.get("transfers.requested"));
                        }
                    }
                }
            } else if (object instanceof Upload) {
                Upload upload = (Upload)transfer;
                switch (upload.getTransferState()) {
                    case FILEHASHING: 
                    case REMOTEMATCHING: {
                        this.bar.setString(Translation.get(upload.getTransferState().getTranslationId()));
                        break;
                    }
                    default: {
                        if (upload.isCompleted()) {
                            Date date = transfer.getCompletedDate();
                            String string = date != null ? Format.formatDateShort(date, true) : "";
                            this.bar.setString(Translation.get("transfers.completed", string));
                            break;
                        }
                        if (upload.isStarted()) {
                            this.bar.setString(Translation.get("transfers.kbs", Format.formatDecimal(transferCounter.calculateCurrentKBS())));
                            break;
                        }
                        this.bar.setString(Translation.get("transfers.queued"));
                    }
                }
            }
            return this.bar;
        }
        if (object instanceof FileInfo) {
            if (n2 == 0) {
                FileInfo fileInfo = (FileInfo)object;
                this.setIcon(Icons.getEnabledIconFor(fileInfo, this.controller));
                this.setText("");
            } else {
                FileInfo fileInfo = (FileInfo)object;
                this.setText(fileInfo.getFilenameOnly());
                this.setIcon(null);
                this.setHorizontalAlignment(2);
            }
        } else if (object instanceof Long) {
            Long l = (Long)object;
            this.setText(Format.formatBytesShort(l));
            this.setIcon(null);
            this.setHorizontalAlignment(4);
        } else if (object instanceof FolderInfo) {
            FolderInfo folderInfo = (FolderInfo)object;
            this.setText(folderInfo.getLocalizedName());
            this.setHorizontalAlignment(2);
        } else if (object instanceof Member) {
            Member member = (Member)object;
            Object object2 = member.getNick();
            if (member.isOnLAN()) {
                object2 = (String)object2 + " (" + Translation.get("transfers.local") + ")";
            }
            this.setText((String)object2);
            this.setHorizontalAlignment(2);
        } else if (object instanceof MemberInfo) {
            MemberInfo memberInfo = (MemberInfo)object;
            String string = memberInfo.nick;
            this.setText(string);
            this.setIcon(null);
            this.setHorizontalAlignment(2);
        } else if (object instanceof EstimatedTime) {
            EstimatedTime estimatedTime = (EstimatedTime)object;
            if (estimatedTime.isActive()) {
                this.setText(Format.formatDeltaTime(estimatedTime.getDeltaTimeMillis()));
            } else {
                this.setText("");
            }
            this.setIcon(null);
            this.setHorizontalAlignment(0);
        } else {
            this.setText(Translation.get("transfers.searching"));
            this.setIcon(null);
            this.setHorizontalAlignment(2);
        }
        if (!bl) {
            this.setBackground(n % 2 == 0 ? ColorUtil.EVEN_TABLE_ROW_COLOR : ColorUtil.ODD_TABLE_ROW_COLOR);
        }
        return component;
    }

    private static boolean shouldShowProblem(TransferProblem transferProblem) {
        return TransferProblem.FILE_NOT_FOUND_EXCEPTION.equals((Object)transferProblem) || TransferProblem.IO_EXCEPTION.equals((Object)transferProblem) || TransferProblem.TEMP_FILE_DELETE.equals((Object)transferProblem) || TransferProblem.TEMP_FILE_OPEN.equals((Object)transferProblem) || TransferProblem.TEMP_FILE_WRITE.equals((Object)transferProblem) || TransferProblem.MD5_ERROR.equals((Object)transferProblem);
    }
}

