/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.preferences;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.dialog.ConfigurationLoaderDialog;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ServerSelectorPanel
extends PFUIComponent {
    private JPanel panel;
    private JTextField addressField;
    private JButton searchButton;

    ServerSelectorPanel(Controller controller) {
        super(controller);
    }

    public Component getUIComponent() {
        if (this.panel == null) {
            this.initComponent();
            FormLayout formLayout = new FormLayout("0:grow, 3dlu, pref", "pref");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            CellConstraints cellConstraints = new CellConstraints();
            panelBuilder.add((Component)this.addressField, cellConstraints.xy(1, 1));
            panelBuilder.add((Component)this.searchButton, cellConstraints.xy(3, 1));
            this.panel = panelBuilder.getPanel();
        }
        return this.panel;
    }

    private void initComponent() {
        this.addressField = new JTextField(this.getController().getOSClient().getServerString());
        this.addressField.setEditable(false);
        this.addressField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                new ConfigurationLoaderDialog(ServerSelectorPanel.this.getController()).openAndWait();
            }
        });
        this.searchButton = new JButtonMini(Icons.getIconById("edit.icon"), Translation.get("general.search"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ConfigurationLoaderDialog(ServerSelectorPanel.this.getController()).openAndWait();
            }
        });
        this.searchButton.setEnabled(true);
    }
}

