/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.notices;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.notices.NoticeBase;
import de.dal33t.powerfolder.ui.notices.NoticeSeverity;

public class WarningNotice
extends NoticeBase {
    private static final long serialVersionUID = 100L;
    private final String message;

    public WarningNotice(String string, String string2, String string3) {
        super(string, string2);
        this.message = string3;
    }

    @Override
    public Runnable getPayload(final Controller controller) {
        return new Runnable(){

            @Override
            public void run() {
                DialogFactory.genericDialog(controller, WarningNotice.this.getTitle(), WarningNotice.this.message, GenericDialogType.WARN);
            }
        };
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean isNotification() {
        return true;
    }

    @Override
    public boolean isActionable() {
        return true;
    }

    @Override
    public NoticeSeverity getNoticeSeverity() {
        return NoticeSeverity.WARNING;
    }

    @Override
    public boolean isPersistable() {
        return true;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.message == null ? 0 : this.message.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WarningNotice warningNotice = (WarningNotice)object;
        return !(this.message == null ? warningNotice.message != null : !this.message.equals(warningNotice.message));
    }
}

