/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.notices;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.model.NoticesModel;
import de.dal33t.powerfolder.ui.notices.Notice;
import de.dal33t.powerfolder.ui.notices.WarningNotice;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;

public class CloudStorageNotice
extends WarningNotice {
    private static final long serialVersionUID = 100L;

    public static CloudStorageNotice almostFull() {
        return new CloudStorageNotice(Translation.get("warning_notice.cloud_almost_full_summary"));
    }

    public static CloudStorageNotice full() {
        return new CloudStorageNotice(Translation.get("warning_notice.cloud_full_summary"));
    }

    private CloudStorageNotice(String string) {
        super(Translation.get("warning_notice.title"), string, null);
    }

    public static void clear(NoticesModel noticesModel) {
        for (Notice notice : noticesModel.getAllNotices()) {
            if (!(notice instanceof CloudStorageNotice)) continue;
            noticesModel.clearNotice(notice);
        }
    }

    @Override
    public Runnable getPayload(Controller controller) {
        String string;
        String string2 = ConfigurationEntry.PROVIDER_BUY_URL.getValue(controller);
        if (StringUtils.isNotBlank(string2)) {
            if (string2.toLowerCase().startsWith("http")) {
                return () -> BrowserLauncher.open(controller, () -> string2);
            }
            string = string2;
        } else {
            string = "/myaccount";
        }
        return () -> BrowserLauncher.open(controller, () -> controller.getOSClient().getWebURL(string, true));
    }
}

