/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.model;

import com.jgoodies.binding.list.LinkedListModel;
import com.jgoodies.binding.list.ObservableList;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.event.NodeManagerAdapter;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.security.SecurityManagerEvent;
import de.dal33t.powerfolder.security.SecurityManagerListener;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.model.SortedTableModel;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.compare.MemberComparator;
import de.dal33t.powerfolder.util.compare.ReverseComparator;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SearchNodeTableModel
extends PFUIComponent
implements TableModel,
SortedTableModel {
    private List<TableModelListener> listeners = new LinkedList<TableModelListener>();
    private final ObservableList<Member> members = new LinkedListModel<Member>();
    private Comparator[] columComparators = new Comparator[COLUMN_NAMES.length];
    private boolean sortAscending;
    private int sortColumn;
    private Comparator<Member> comparator;
    private static final String[] COLUMN_NAMES = new String[]{Translation.get("exp.friend_search.node_table.name"), Translation.get("exp.friend_search.node_table.account"), Translation.get("exp.friend_search.node_table.last_seen_online"), Translation.get("exp.friend_search.node_table.ip"), Translation.get("exp.friend_search.node_table.on_local_network")};

    public SearchNodeTableModel(Controller controller) {
        super(controller);
        controller.getNodeManager().addNodeManagerListener(new MyNodeManagerListener());
        controller.getSecurityManager().addListener(new MySecurityManagerListener());
        this.members.addListDataListener(new ListModelListener());
        this.columComparators[0] = MemberComparator.NICK;
        this.columComparators[1] = MemberComparator.DISPLAY_NAME;
        this.columComparators[2] = MemberComparator.BY_LAST_CONNECT_DATE;
        this.columComparators[3] = MemberComparator.IP;
        this.columComparators[4] = MemberComparator.BY_CONNECTION_TYPE;
    }

    public void clear() {
        this.members.clear();
    }

    public void add(Member member) {
        Reject.ifNull(member, "Member is null");
        this.logFine("add member id: '" + member.getId() + "'");
        this.members.add(member);
        this.sort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sort() {
        if (this.comparator != null) {
            ObservableList<Member> observableList = this.members;
            synchronized (observableList) {
                if (this.sortAscending) {
                    Collections.sort(this.members, this.comparator);
                } else {
                    Collections.sort(this.members, new ReverseComparator<Member>(this.comparator));
                }
            }
            this.fireModelChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean sortBy(int n) {
        if (n < 0 && n > this.columComparators.length || this.columComparators[n] == null) {
            this.comparator = null;
            this.sortColumn = -1;
            return false;
        }
        this.sortColumn = n;
        return this.sortBy(this.columComparators[n]);
    }

    public void reverseList() {
        this.sortAscending = !this.sortAscending;
        this.sort();
    }

    private boolean sortBy(Comparator<Member> comparator) {
        Comparator<Member> comparator2 = this.comparator;
        this.comparator = comparator;
        if (!Util.equals(comparator2, comparator)) {
            return this.sort();
        }
        return false;
    }

    public boolean contains(Member member) {
        return this.members.contains(member);
    }

    public void remove(Member member) {
        Reject.ifNull(member, "Member is null");
        this.members.remove(member);
    }

    public boolean containsNoUsers() {
        return this.members.isEmpty();
    }

    public ObservableList<Member> getListModel() {
        return this.members;
    }

    @Override
    public int getRowCount() {
        return Math.max(this.members.size(), 1);
    }

    public Object getDataAt(int n) {
        if (this.members.isEmpty()) {
            return "";
        }
        return this.members.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.getDataAt(n);
    }

    public Class<Member> getColumnClass(int n) {
        return Member.class;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        throw new IllegalStateException("not editable");
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    private void updateNode(Member member) {
        int n = this.members.indexOf(member);
        if (n < 0) {
            return;
        }
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, -1, 0);
        this.fireTableModelEvent(tableModelEvent);
    }

    private void fireModelChanged() {
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, this.getRowCount(), -1, 0);
        this.fireTableModelEvent(tableModelEvent);
    }

    private void fireModelStructureChanged() {
        TableModelEvent tableModelEvent = new TableModelEvent(this);
        this.fireTableModelEvent(tableModelEvent);
    }

    private void fireTableModelEvent(final TableModelEvent tableModelEvent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (TableModelListener tableModelListener : SearchNodeTableModel.this.listeners) {
                    tableModelListener.tableChanged(tableModelEvent);
                }
            }
        };
        UIUtil.invokeLaterInEDT(runnable);
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public void setAscending(boolean bl) {
        this.sortAscending = bl;
    }

    private class MyNodeManagerListener
    extends NodeManagerAdapter {
        private MyNodeManagerListener() {
        }

        @Override
        public void nodeConnected(NodeManagerEvent nodeManagerEvent) {
            SearchNodeTableModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeDisconnected(NodeManagerEvent nodeManagerEvent) {
            SearchNodeTableModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeOffline(NodeManagerEvent nodeManagerEvent) {
            SearchNodeTableModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeOnline(NodeManagerEvent nodeManagerEvent) {
            SearchNodeTableModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public void friendAdded(NodeManagerEvent nodeManagerEvent) {
            SearchNodeTableModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public void friendRemoved(NodeManagerEvent nodeManagerEvent) {
            SearchNodeTableModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public void settingsChanged(NodeManagerEvent nodeManagerEvent) {
            SearchNodeTableModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }

    private class MySecurityManagerListener
    implements SecurityManagerListener {
        private MySecurityManagerListener() {
        }

        @Override
        public void nodeAccountStateChanged(SecurityManagerEvent securityManagerEvent) {
            SearchNodeTableModel.this.updateNode(securityManagerEvent.getNode());
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class ListModelListener
    implements ListDataListener {
        private ListModelListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            SearchNodeTableModel.this.fireModelStructureChanged();
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            SearchNodeTableModel.this.fireModelStructureChanged();
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            SearchNodeTableModel.this.fireModelChanged();
        }
    }
}

