/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.model;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.FileInBasePathWarning;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.message.Invitation;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.notices.FolderAutoCreateNotice;
import de.dal33t.powerfolder.ui.notices.InvitationNotice;
import de.dal33t.powerfolder.ui.notices.Notice;
import de.dal33t.powerfolder.ui.notices.NoticeSeverity;
import de.dal33t.powerfolder.ui.notices.OutOfMemoryNotice;
import de.dal33t.powerfolder.ui.notices.RunnableNotice;
import de.dal33t.powerfolder.ui.notices.WarningNotice;
import de.dal33t.powerfolder.ui.notification.NotificationHandlerBase;
import de.dal33t.powerfolder.ui.notification.SystemNotificationHandler;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.ConfigurationLoader;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;

public class NoticesModel
extends PFUIComponent {
    private final ValueModel allNoticesCountVM = new ValueHolder();
    private final ValueModel unreadNoticesCountVM = new ValueHolder();
    private final List<Notice> notices = new CopyOnWriteArrayList<Notice>();

    public NoticesModel(Controller controller) {
        super(controller);
        this.updateNoticeCounts();
    }

    public ValueModel getAllNoticesCountVM() {
        return this.allNoticesCountVM;
    }

    public ValueModel getUnreadNoticesCountVM() {
        return this.unreadNoticesCountVM;
    }

    private void addNotice(Notice notice) {
        if (this.notices.contains(notice)) {
            this.logFine("Ignoring existing notice: " + notice);
        } else {
            this.notices.add(notice);
            this.updateNoticeCounts();
        }
    }

    public List<Notice> getAllNotices() {
        return Collections.unmodifiableList(this.notices);
    }

    public Notice getFirstUnread() {
        for (Notice notice : this.notices) {
            if (notice.isRead()) continue;
            return notice;
        }
        return null;
    }

    public NoticeSeverity getHighestUnreadSeverity() {
        NoticeSeverity noticeSeverity = null;
        for (Notice notice : this.notices) {
            if (notice.isRead()) continue;
            if (notice.getNoticeSeverity() == NoticeSeverity.WARNING) {
                return NoticeSeverity.WARNING;
            }
            if (notice.getNoticeSeverity() != NoticeSeverity.INFORMATION) continue;
            noticeSeverity = NoticeSeverity.INFORMATION;
        }
        return noticeSeverity;
    }

    public void handleNotice(Notice notice) {
        this.handleSystemNotice(notice, false);
    }

    public void handleSystemNotice(Notice notice, boolean bl) {
        Object object;
        if (!this.getUIController().isStarted() || this.getController().isShuttingDown() || this.notices.contains(notice)) {
            return;
        }
        this.removeDuplicateInvitations(notice);
        if (((Boolean)this.getApplicationModel().getSystemNotificationsValueModel().getValue()).booleanValue() && notice.isNotification() && !notice.isRead() && !PFWizard.isWizardOpen() && !bl) {
            object = new SystemNotificationHandler(this.getController(), notice);
            ((NotificationHandlerBase)object).show();
        }
        if (notice.isActionable()) {
            if (notice instanceof InvitationNotice) {
                object = (InvitationNotice)notice;
                Invitation serializable = ((InvitationNotice)object).getPayload(this.getController());
                FolderInfo folderInfo = serializable.folder;
                if (this.getController().getFolderRepository().hasJoinedFolder(folderInfo)) {
                    return;
                }
            }
            for (Notice notice2 : this.notices) {
                if (notice2.isRead() || !notice2.equals(notice)) continue;
                return;
            }
            this.addNotice(notice);
        }
    }

    private void removeDuplicateInvitations(Notice notice) {
        if (notice instanceof InvitationNotice) {
            InvitationNotice invitationNotice = (InvitationNotice)notice;
            Invitation invitation = invitationNotice.getPayload(this.getController());
            for (Notice notice2 : this.notices) {
                InvitationNotice invitationNotice2;
                Invitation invitation2;
                if (!(notice2 instanceof InvitationNotice) || !(invitation2 = (invitationNotice2 = (InvitationNotice)notice2).getPayload(this.getController())).getOID().equals(invitation.getOID())) continue;
                this.notices.remove(notice2);
            }
        }
    }

    public void activateNotice(Notice notice) {
        if (notice instanceof InvitationNotice) {
            InvitationNotice invitationNotice = (InvitationNotice)notice;
            this.handleInvitationNotice(invitationNotice);
        } else if (notice instanceof WarningNotice) {
            WarningNotice warningNotice = (WarningNotice)notice;
            SwingUtilities.invokeLater(warningNotice.getPayload(this.getController()));
        } else if (notice instanceof RunnableNotice) {
            RunnableNotice runnableNotice = (RunnableNotice)notice;
            SwingUtilities.invokeLater(runnableNotice.getPayload(this.getController()));
        } else if (notice instanceof FolderAutoCreateNotice) {
            FolderAutoCreateNotice folderAutoCreateNotice = (FolderAutoCreateNotice)notice;
            this.handleFolderAutoCreateNotice(folderAutoCreateNotice);
        } else if (notice instanceof OutOfMemoryNotice) {
            OutOfMemoryNotice outOfMemoryNotice = (OutOfMemoryNotice)notice;
            this.handleOutOfMemoryNotice(outOfMemoryNotice);
        } else {
            this.logWarning("Don't know what to do with notice: " + notice.getClass().getName() + " : " + notice.toString());
        }
        this.markRead(notice);
    }

    private void handleOutOfMemoryNotice(OutOfMemoryNotice outOfMemoryNotice) {
        String string = Help.getWikiArticleURL(this.getController(), "Memory_configuration");
        String string2 = Translation.get("low_memory.error.text", string);
        int n = DialogFactory.genericDialog(this.getController(), Translation.get("low_memory.error.title"), string2, new String[]{Translation.get("general.ok"), Translation.get("dialog.already_running.exit_button")}, 0, GenericDialogType.ERROR);
        if (n == 1) {
            this.getController().exit(0);
        }
    }

    private void handleFolderAutoCreateNotice(FolderAutoCreateNotice folderAutoCreateNotice) {
        PFWizard.openFolderAutoCreateWizard(this.getController(), folderAutoCreateNotice.getFolderInfo());
    }

    public void markRead(Notice notice) {
        notice.setRead();
        this.updateNoticeCounts();
    }

    private void handleInvitationNotice(InvitationNotice invitationNotice) {
        Invitation invitation = invitationNotice.getPayload(this.getController());
        PFWizard.openInvitationReceivedWizard(this.getController(), invitation);
    }

    public void clearAll() {
        for (Notice notice : this.notices) {
            Invitation invitation;
            if (!(notice instanceof InvitationNotice) || (invitation = ((InvitationNotice)notice).getPayload(this.getController())) == null || !this.serverAgreeInvitationEnabled(invitation)) continue;
            this.getController().getThreadPool().execute(new DeclineInvitationTask(((InvitationNotice)notice).getPayload(this.getController())));
        }
        this.notices.clear();
        this.updateNoticeCounts();
    }

    public void clearNotice(Notice notice) {
        for (Notice notice2 : this.notices) {
            Invitation invitation;
            if (!notice.equals(notice2)) continue;
            if (notice2 instanceof InvitationNotice && (invitation = ((InvitationNotice)notice2).getPayload(this.getController())) != null && this.serverAgreeInvitationEnabled(invitation)) {
                this.getController().getThreadPool().execute(new DeclineInvitationTask(((InvitationNotice)notice2).getPayload(this.getController())));
            }
            this.notices.remove(notice);
            this.updateNoticeCounts();
            return;
        }
    }

    private boolean serverAgreeInvitationEnabled(Invitation invitation) {
        boolean bl = ConfigurationEntry.FOLDER_AGREE_INVITATION_ENABLED.getValueBoolean(this.getController());
        if (invitation.getServer() != null && ConfigurationEntry.SERVER_FEDERATED_LOGIN.getValueBoolean(this.getController()).booleanValue()) {
            try {
                Properties properties = ConfigurationLoader.loadPreConfiguration(invitation.getServer().getWebUrl());
                String string = (String)properties.get(ConfigurationEntry.FOLDER_AGREE_INVITATION_ENABLED.getConfigKey());
                if (StringUtils.isNotBlank(string)) {
                    bl = Boolean.parseBoolean(string);
                }
            }
            catch (IOException iOException) {
                this.logWarning("Failed to get config from federation server " + invitation.getServer().getWebUrl());
                return bl;
            }
        }
        return bl;
    }

    public void clearAllFileInBasePathWarnings() {
        for (Notice notice : this.getAllNotices()) {
            if (!(notice instanceof FileInBasePathWarning)) continue;
            this.clearNotice(notice);
        }
    }

    private void updateNoticeCounts() {
        this.allNoticesCountVM.setValue(this.notices.size());
        int n = 0;
        for (Notice notice : this.notices) {
            if (notice.isRead()) continue;
            ++n;
        }
        this.unreadNoticesCountVM.setValue(n);
    }

    public int getUnreadNoticesCount() {
        return (Integer)this.unreadNoticesCountVM.getValue();
    }

    private class DeclineInvitationTask
    implements Runnable {
        Invitation invitation;

        public DeclineInvitationTask(Invitation invitation) {
            this.invitation = invitation;
        }

        @Override
        public void run() {
            ServerClient serverClient = NoticesModel.this.getController().getOSClient();
            if (serverClient.isLoggedIn() && serverClient.getAccount().hasReadPermissions(this.invitation.getPermission().getFolder())) {
                serverClient.getSecurityService().declineInvitation(this.invitation);
            }
        }
    }
}

