/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.notices;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.information.InformationCard;
import de.dal33t.powerfolder.ui.information.InformationCardType;
import de.dal33t.powerfolder.ui.information.notices.NoticesTable;
import de.dal33t.powerfolder.ui.information.notices.NoticesTableModel;
import de.dal33t.powerfolder.ui.model.NoticesModel;
import de.dal33t.powerfolder.ui.notices.Notice;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NoticesInformationCard
extends InformationCard {
    private JPanel uiComponent;
    private NoticesModel model;
    private NoticesTableModel noticesTableModel;
    private NoticesTable noticesTable;
    private Action activateAction;
    private JPopupMenu actionsMenu;

    public NoticesInformationCard(Controller controller) {
        super(controller);
        this.model = controller.getUIController().getApplicationModel().getNoticesModel();
    }

    @Override
    public InformationCardType getInformationCardType() {
        return InformationCardType.NOTICES;
    }

    private void buildPopupMenus() {
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(this.activateAction);
        this.actionsMenu.add(new CleanupNoticesAction(this.getController()));
    }

    @Override
    public Image getCardImage() {
        return Icons.getImageById("information.icon");
    }

    @Override
    public String getCardTitle() {
        return Translation.get("dialog.notices.title");
    }

    @Override
    public JComponent getUIComponent() {
        if (this.uiComponent == null) {
            this.initialize();
            this.buildUIComponent();
        }
        return this.uiComponent;
    }

    private void initialize() {
        MyPropertyChangeListener myPropertyChangeListener = new MyPropertyChangeListener();
        this.getController().getUIController().getApplicationModel().getNoticesModel().getAllNoticesCountVM().addValueChangeListener(myPropertyChangeListener);
        this.noticesTableModel = new NoticesTableModel(this.getController());
        this.noticesTable = new NoticesTable(this.noticesTableModel);
        this.noticesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                NoticesInformationCard.this.enableActivate();
            }
        });
        this.noticesTable.addMouseListener(new TableMouseListener());
        this.activateAction = new ActivateNoticeAction(this.getController());
        this.enableActivate();
    }

    private void buildUIComponent() {
        FormLayout formLayout = new FormLayout("3dlu, pref:grow, 3dlu", "3dlu, pref, 3dlu, pref, 3dlu, fill:pref:grow, 3dlu");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        JScrollPane jScrollPane = new JScrollPane(this.noticesTable);
        defaultFormBuilder.add((Component)this.buildToolbar().getPanel(), cellConstraints.xy(2, 2));
        defaultFormBuilder.addSeparator(null, cellConstraints.xyw(1, 4, 3));
        defaultFormBuilder.add((Component)jScrollPane, cellConstraints.xy(2, 6));
        this.uiComponent = defaultFormBuilder.getPanel();
        this.buildPopupMenus();
    }

    private ButtonBarBuilder buildToolbar() {
        JButton jButton = new JButton(this.activateAction);
        JButton jButton2 = new JButton(new CleanupNoticesAction(this.getController()));
        ButtonBarBuilder buttonBarBuilder = ButtonBarBuilder.createLeftToRightBuilder();
        buttonBarBuilder.addGridded(jButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addGridded(jButton2);
        return buttonBarBuilder;
    }

    private void updateTableModel() {
        this.noticesTableModel.reset();
    }

    private void enableActivate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NoticesInformationCard.this.activateAction.setEnabled(NoticesInformationCard.this.noticesTable.getSelectedRowCount() > 0);
            }
        });
    }

    private void activateNotice() {
        Object object;
        int n = this.noticesTable.getSelectedRow();
        if (n >= 0 && (object = this.noticesTableModel.getValueAt(n, 0)) != null && object instanceof Notice) {
            Notice notice = (Notice)object;
            this.model.activateNotice(notice);
        }
    }

    private class CleanupNoticesAction
    extends BaseAction {
        CleanupNoticesAction(Controller controller) {
            super("action_cleanup_notices", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = NoticesInformationCard.this.noticesTable.getSelectedRow();
            if (n < 0) {
                this.getController().getUIController().getApplicationModel().getNoticesModel().clearAll();
            } else {
                Object object = NoticesInformationCard.this.noticesTableModel.getValueAt(n, 0);
                if (object != null && object instanceof Notice) {
                    Notice notice = (Notice)object;
                    this.getController().getUIController().getApplicationModel().getNoticesModel().clearNotice(notice);
                }
            }
        }
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            NoticesInformationCard.this.updateTableModel();
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                NoticesInformationCard.this.activateNotice();
            }
        }

        private void showContextMenu(MouseEvent mouseEvent) {
            NoticesInformationCard.this.actionsMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class ActivateNoticeAction
    extends BaseAction {
        ActivateNoticeAction(Controller controller) {
            super("action_activate_notice", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            int n = NoticesInformationCard.this.noticesTable.getSelectedRow();
            if (n >= 0 && (object = NoticesInformationCard.this.noticesTableModel.getValueAt(n, 0)) != null && object instanceof Notice) {
                Notice notice = (Notice)object;
                NoticesInformationCard.this.model.activateNotice(notice);
            }
        }
    }
}

