/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.problems;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.problem.Problem;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.ui.information.folder.problems.ProblemsTableModel;
import de.dal33t.powerfolder.ui.render.SortedTableHeaderRenderer;
import de.dal33t.powerfolder.ui.util.ColorUtil;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ProblemsTable
extends JTable {
    private final Controller controller;

    public ProblemsTable(ProblemsTableModel problemsTableModel, Controller controller) {
        super(problemsTableModel);
        this.controller = controller;
        this.setColumnSelectionAllowed(false);
        this.setShowGrid(false);
        this.setupColumns();
        this.setRowHeight(Icons.getIconById("problems.icon").getIconHeight() + 4);
        this.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        ProblemTableCellRenderer problemTableCellRenderer = new ProblemTableCellRenderer();
        this.setDefaultRenderer(Problem.class, problemTableCellRenderer);
        SortedTableHeaderRenderer.associateHeaderRenderer(problemsTableModel, this.getColumnModel(), 0, true);
    }

    private void setupColumns() {
        int n = this.getWidth();
        this.getTableHeader().setPreferredSize(new Dimension(n, 20));
        TableColumn tableColumn = this.getColumn(this.getColumnName(0));
        tableColumn.setPreferredWidth(Icons.getIconById("problems.icon").getIconWidth() + 4);
        tableColumn = this.getColumn(this.getColumnName(1));
        tableColumn.setPreferredWidth(350);
        tableColumn = this.getColumn(this.getColumnName(2));
        tableColumn.setPreferredWidth(300);
        tableColumn = this.getColumn(this.getColumnName(3));
        tableColumn.setPreferredWidth(100);
    }

    private class TableHeaderMouseListener
    extends MouseAdapter {
        private TableHeaderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n);
                int n2 = tableColumn.getModelIndex();
                TableModel tableModel = jTableHeader.getTable().getModel();
                if (tableModel instanceof ProblemsTableModel) {
                    ProblemsTableModel problemsTableModel = (ProblemsTableModel)tableModel;
                    problemsTableModel.sortBy(n2);
                }
            }
        }
    }

    private class ProblemTableCellRenderer
    extends DefaultTableCellRenderer {
        private ProblemTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Problem) {
                Problem problem = (Problem)object;
                if (n2 == 0) {
                    this.setIcon(Icons.getIconById("warning.icon"));
                    this.setText("");
                } else if (n2 == 1) {
                    this.setIcon(null);
                    this.setText(problem.getDescription());
                } else if (n2 == 2) {
                    if (problem instanceof ResolvableProblem) {
                        ResolvableProblem resolvableProblem = (ResolvableProblem)problem;
                        this.setText(resolvableProblem.getResolutionDescription());
                    } else {
                        this.setText(Translation.get("folder_problem.table_model.not_available"));
                    }
                } else if (n2 == 3) {
                    this.setText(Format.formatDateShort(problem.getDate()));
                }
            }
            if (!bl) {
                this.setBackground(n % 2 == 0 ? ColorUtil.EVEN_TABLE_ROW_COLOR : ColorUtil.ODD_TABLE_ROW_COLOR);
            }
            return component;
        }
    }
}

