/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.problems;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.problem.Problem;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.information.folder.problems.ProblemsTable;
import de.dal33t.powerfolder.ui.information.folder.problems.ProblemsTableModel;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProblemsTab
extends PFUIComponent {
    private JPanel uiComponent;
    private JScrollPane scrollPane;
    private MyOpenProblemAction openProblemAction;
    private MyResolveProblemAction resolveProblemAction;
    private MyCleanupProblemAction cleanupProblemAction;
    private FolderInfo folderInfo;
    private final ProblemsTable problemsTable;
    private final ProblemsTableModel problemsTableModel;
    private Problem selectedProblem;

    public ProblemsTab(Controller controller) {
        super(controller);
        this.problemsTableModel = new ProblemsTableModel(controller);
        this.problemsTable = new ProblemsTable(this.problemsTableModel, controller);
        this.problemsTable.getSelectionModel().setSelectionMode(0);
        this.problemsTable.getSelectionModel().addListSelectionListener(new MySelectionListener());
        this.problemsTable.addMouseListener(new TableMouseListener());
    }

    public JPanel getUIComponent() {
        if (this.uiComponent == null) {
            this.initialize();
            this.buildUIComponent();
            this.enableOnSelection();
        }
        return this.uiComponent;
    }

    private void initialize() {
        this.openProblemAction = new MyOpenProblemAction(this.getController());
        this.resolveProblemAction = new MyResolveProblemAction(this.getController());
        this.cleanupProblemAction = new MyCleanupProblemAction(this.getController());
        this.scrollPane = new JScrollPane(this.problemsTable);
        UIUtil.whiteStripTable(this.problemsTable);
        UIUtil.removeBorder(this.scrollPane);
        UIUtil.setZeroHeight(this.scrollPane);
    }

    private void buildUIComponent() {
        FormLayout formLayout = new FormLayout("3dlu, fill:pref:grow, 3dlu", "3dlu, pref, 3dlu, pref , 3dlu, fill:0:grow, 3dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add(this.createToolBar(), cellConstraints.xy(2, 2));
        panelBuilder.addSeparator(null, cellConstraints.xyw(1, 4, 3));
        panelBuilder.add((Component)this.scrollPane, cellConstraints.xy(2, 6));
        this.uiComponent = panelBuilder.getPanel();
    }

    private Component createToolBar() {
        JButton jButton;
        ButtonBarBuilder buttonBarBuilder = ButtonBarBuilder.createLeftToRightBuilder();
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            jButton = new JButton(this.openProblemAction);
            jButton.setIcon(null);
            buttonBarBuilder.addGridded(jButton);
            buttonBarBuilder.addRelatedGap();
            buttonBarBuilder.addRelatedGap();
        }
        jButton = new JButton(this.resolveProblemAction);
        jButton.setIcon(null);
        buttonBarBuilder.addGridded(jButton);
        buttonBarBuilder.addRelatedGap();
        JButton jButton2 = new JButton(this.cleanupProblemAction);
        jButton2.setIcon(null);
        buttonBarBuilder.addGridded(jButton2);
        return buttonBarBuilder.getPanel();
    }

    public void setFolderInfo(FolderInfo folderInfo) {
        this.folderInfo = folderInfo;
        this.selectedProblem = null;
        if (this.problemsTableModel.getRowCount() > 0) {
            this.problemsTable.getSelectionModel().setSelectionInterval(0, 0);
        } else {
            this.problemsTable.getSelectionModel().removeIndexInterval(0, this.problemsTableModel.getRowCount());
        }
    }

    public void updateProblems(List<Problem> list) {
        this.problemsTableModel.updateProblems(list);
        this.enableOnSelection();
        if (this.getUIController().isShowingFolder() && !ConfigurationEntry.FILES_ENABLED.getValueBoolean(this.getController()).booleanValue() && list.isEmpty()) {
            this.getUIController().getMainFrame().hideInlineInfoPanel();
        }
    }

    private void enableOnSelection() {
        this.getUIComponent();
        int n = this.problemsTable.getSelectedRow();
        if (n >= 0) {
            this.selectedProblem = (Problem)this.problemsTableModel.getValueAt(this.problemsTable.getSelectedRow(), 0);
            if (this.selectedProblem.getWikiLinkKey() == null) {
                this.openProblemAction.setEnabled(false);
            } else {
                this.openProblemAction.setEnabled(true);
            }
            this.resolveProblemAction.setEnabled(this.selectedProblem instanceof ResolvableProblem);
            this.logFiner("Selected row: " + this.problemsTable.getSelectedRow() + ". Problem: " + this.selectedProblem);
        } else {
            this.selectedProblem = null;
            this.openProblemAction.setEnabled(false);
            this.resolveProblemAction.setEnabled(false);
        }
        this.cleanupProblemAction.setEnabled(true);
    }

    public void resolveProblem() {
        int n = this.problemsTable.getSelectedRow();
        Problem problem = (Problem)this.problemsTableModel.getValueAt(n, 0);
        String string = Help.getWikiArticleURL(this.getController(), problem.getWikiLinkKey());
        if (StringUtils.isNotBlank(string)) {
            BrowserLauncher.openURL(this.getController(), string);
        }
    }

    private class MySelectionListener
    implements ListSelectionListener {
        private MySelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ProblemsTab.this.enableOnSelection();
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                ProblemsTab.this.resolveProblem();
            }
        }
    }

    private class MyOpenProblemAction
    extends BaseAction {
        private MyOpenProblemAction(Controller controller) {
            super("action_open_problem", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProblemsTab.this.resolveProblem();
        }
    }

    private class MyResolveProblemAction
    extends BaseAction {
        MyResolveProblemAction(Controller controller) {
            super("action_resolve_problem", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ProblemsTab.this.selectedProblem != null && ProblemsTab.this.selectedProblem instanceof ResolvableProblem) {
                ResolvableProblem resolvableProblem = (ResolvableProblem)ProblemsTab.this.selectedProblem;
                SwingUtilities.invokeLater(resolvableProblem.resolution(this.getController()));
                resolvableProblem.getFolder(this.getController()).removeProblem(resolvableProblem);
            } else {
                ProblemsTab.this.logSevere("Tried to resolve a non-resolvable problem " + (ProblemsTab.this.selectedProblem == null ? null : ProblemsTab.this.selectedProblem.getClass().getName()));
            }
        }
    }

    private class MyCleanupProblemAction
    extends BaseAction {
        MyCleanupProblemAction(Controller controller) {
            super("action_cleanup_problem", controller);
        }

        private void cleanup(Problem problem) {
            if (problem instanceof ResolvableProblem) {
                ResolvableProblem resolvableProblem = (ResolvableProblem)problem;
                resolvableProblem.ignore(this.getController());
            } else {
                ProblemsTab.this.logSevere("Tried to clean up a non-resolvable problem " + (problem == null ? null : problem.getClass().getName()));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ProblemsTab.this.selectedProblem != null) {
                this.cleanup(ProblemsTab.this.selectedProblem);
            } else {
                while (ProblemsTab.this.problemsTableModel.getRowCount() > 0) {
                    this.cleanup((Problem)ProblemsTab.this.problemsTableModel.getValueAt(0, 0));
                }
            }
        }
    }
}

