/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.members;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.ConnectDialog;
import de.dal33t.powerfolder.ui.information.folder.members.MembersExpertTable;
import de.dal33t.powerfolder.ui.information.folder.members.MembersExpertTableModel;
import de.dal33t.powerfolder.ui.information.folder.members.MembersTab;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MembersExpertTab
extends PFUIComponent
implements MembersTab {
    private JPanel uiComponent;
    private MembersExpertTableModel model = new MembersExpertTableModel(this.getController());
    private JScrollPane scrollPane;
    private BaseAction inviteAction;
    private Action reconnectAction;
    private JButton refreshButton;
    private MembersExpertTable membersTable;
    private Member selectedMember;
    private JProgressBar refreshBar;

    public MembersExpertTab(Controller controller) {
        super(controller);
        this.model.sortBy(0);
    }

    @Override
    public void setFolderInfo(FolderInfo folderInfo) {
        this.model.setFolderInfo(folderInfo);
        this.inviteAction.allowWith(FolderPermission.admin(folderInfo));
    }

    @Override
    public JPanel getUIComponent() {
        if (this.uiComponent == null) {
            this.initialize();
            this.buildUIComponent();
        }
        return this.uiComponent;
    }

    public void initialize() {
        this.inviteAction = new MyInviteAction();
        this.reconnectAction = new MyReconnectAction();
        Action action = this.model.getRefreshAction();
        this.refreshButton = new JButton(action);
        this.refreshBar = new JProgressBar();
        this.refreshBar.setIndeterminate(true);
        this.refreshBar.setVisible(false);
        this.membersTable = new MembersExpertTable(this.model);
        this.membersTable.getSelectionModel().setSelectionMode(0);
        this.membersTable.getSelectionModel().addListSelectionListener(new MySelectionListener());
        this.scrollPane = new JScrollPane(this.membersTable);
        this.membersTable.addMouseListener(new TableMouseListener());
        UIUtil.whiteStripTable(this.membersTable);
        UIUtil.removeBorder(this.scrollPane);
        UIUtil.setZeroHeight(this.scrollPane);
        this.enableOnSelection();
    }

    private void buildUIComponent() {
        FormLayout formLayout = new FormLayout("3dlu, fill:pref:grow, 3dlu", "3dlu, pref, 3dlu, pref , 3dlu, fill:0:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.createToolBar(), cellConstraints.xy(2, 2));
        panelBuilder.addSeparator(null, cellConstraints.xyw(1, 4, 3));
        panelBuilder.add((Component)this.scrollPane, cellConstraints.xy(2, 6));
        this.uiComponent = panelBuilder.getPanel();
    }

    private JPanel createToolBar() {
        JButton jButton = new JButton(this.inviteAction);
        JButton jButton2 = new JButton(this.reconnectAction);
        FormLayout formLayout = new FormLayout("0:grow", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.refreshButton, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.refreshBar, cellConstraints.xy(1, 1));
        this.enableOnSelection();
        ButtonBarBuilder buttonBarBuilder = ButtonBarBuilder.createLeftToRightBuilder();
        if (ConfigurationEntry.SERVER_INVITE_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            buttonBarBuilder.addGridded(jButton);
        }
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            buttonBarBuilder.addRelatedGap();
            buttonBarBuilder.addGridded(jButton2);
            buttonBarBuilder.addRelatedGap();
            buttonBarBuilder.addGridded(panelBuilder.getPanel());
        }
        JPanel jPanel = buttonBarBuilder.getPanel();
        formLayout = new FormLayout("pref, 0:grow, pref", "pref");
        panelBuilder = new PanelBuilder(formLayout);
        cellConstraints = new CellConstraints();
        panelBuilder.add((Component)jPanel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)Help.createWikiLinkButton(this.getController(), "Security_Permissions"), cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private void enableOnSelection() {
        int n = this.membersTable.getSelectedRow();
        Member member = this.selectedMember = n >= 0 ? this.model.getMemberAt(this.membersTable.getSelectedRow()) : null;
        if (this.selectedMember != null) {
            if (this.selectedMember.equals(this.getController().getMySelf())) {
                this.reconnectAction.setEnabled(false);
            } else {
                this.reconnectAction.setEnabled(true);
            }
        } else {
            this.selectedMember = null;
            this.reconnectAction.setEnabled(false);
        }
    }

    private class MyInviteAction
    extends BaseAction {
        private MyInviteAction() {
            super("action_invite_friend", MembersExpertTab.this.getController());
            this.setIcon(null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PFWizard.openSendInvitationWizard(this.getController(), MembersExpertTab.this.model.getFolderInfo());
            MembersExpertTab.this.model.refreshModel();
        }
    }

    private class MyReconnectAction
    extends BaseAction {
        MyReconnectAction() {
            super("exp.action_reconnect", MembersExpertTab.this.getController());
            this.setIcon(null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MembersExpertTab.this.selectedMember == null) {
                return;
            }
            final ConnectDialog connectDialog = new ConnectDialog(this.getController(), UIUtil.getParentWindow(actionEvent));
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    block3: {
                        Member member = MembersExpertTab.this.selectedMember;
                        connectDialog.open(member.getNick());
                        member.shutdown();
                        try {
                            if (member.reconnect().isFailure()) {
                                throw new ConnectionException(Translation.get("dialog.unable_to_connect_to_member", member.getNick()));
                            }
                        }
                        catch (ConnectionException connectionException) {
                            connectDialog.close();
                            if (connectDialog.isCanceled() || member.isConnected()) break block3;
                            connectionException.show(MyReconnectAction.this.getController());
                        }
                    }
                    connectDialog.close();
                }
            };
            new Thread(runnable, "Reconnector to " + MembersExpertTab.this.selectedMember.getNick()).start();
        }
    }

    private class MySelectionListener
    implements ListSelectionListener {
        private MySelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            MembersExpertTab.this.enableOnSelection();
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        private void showContextMenu(MouseEvent mouseEvent) {
        }
    }
}

