/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.files.versions;

import de.dal33t.powerfolder.ui.information.folder.files.versions.FileInfoVersionTypeHolder;
import de.dal33t.powerfolder.ui.information.folder.files.versions.FileVersionsTableModel;
import de.dal33t.powerfolder.ui.render.SortedTableHeaderRenderer;
import de.dal33t.powerfolder.ui.util.ColorUtil;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FileVersionsTable
extends JTable {
    public FileVersionsTable(FileVersionsTableModel fileVersionsTableModel) {
        super(fileVersionsTableModel);
        this.setColumnSelectionAllowed(false);
        this.setShowGrid(false);
        this.getSelectionModel().setSelectionMode(0);
        this.setupColumns();
        this.setDefaultRenderer(FileInfoVersionTypeHolder.class, new MyDefaultTreeCellRenderer());
        this.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        SortedTableHeaderRenderer.associateHeaderRenderer(fileVersionsTableModel, this.getColumnModel(), 1, false);
    }

    private void setupColumns() {
        int n = this.getWidth();
        this.getTableHeader().setPreferredSize(new Dimension(n, 20));
        Icon icon = Icons.getIconById("folder.icon");
        this.setRowHeight(icon.getIconHeight() + 2);
        TableColumn tableColumn = this.getColumn(this.getColumnName(0));
        tableColumn.setPreferredWidth(icon.getIconWidth() + 2);
        tableColumn.setMinWidth(icon.getIconWidth() + 2);
        tableColumn.setMaxWidth(icon.getIconWidth() + 2);
        tableColumn = this.getColumn(this.getColumnName(1));
        tableColumn.setPreferredWidth(40);
        tableColumn = this.getColumn(this.getColumnName(2));
        tableColumn.setPreferredWidth(40);
        tableColumn = this.getColumn(this.getColumnName(3));
        tableColumn.setPreferredWidth(40);
    }

    public FileInfoVersionTypeHolder getSelectedInfo() {
        int n = this.getSelectedRow();
        if (n >= 0) {
            FileVersionsTableModel fileVersionsTableModel = (FileVersionsTableModel)this.getModel();
            return (FileInfoVersionTypeHolder)fileVersionsTableModel.getValueAt(n, 0);
        }
        return null;
    }

    private class MyDefaultTreeCellRenderer
    extends DefaultTableCellRenderer {
        private MyDefaultTreeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            FileInfoVersionTypeHolder fileInfoVersionTypeHolder = (FileInfoVersionTypeHolder)object;
            this.setIcon(null);
            String string = "";
            String string2 = null;
            switch (n2) {
                case 0: {
                    this.setIcon(null);
                    string = "";
                    string2 = fileInfoVersionTypeHolder.isOnline() ? Translation.get("file_versions_table_model.online") : Translation.get("file_versions_table_model.local");
                    break;
                }
                case 1: {
                    string = Format.formatDateShort(fileInfoVersionTypeHolder.getFileInfo().getModifiedDate());
                    this.setHorizontalAlignment(4);
                    break;
                }
                case 2: {
                    string = String.valueOf(fileInfoVersionTypeHolder.getFileInfo().getVersion());
                    this.setHorizontalAlignment(4);
                    break;
                }
                case 3: {
                    string = Format.formatBytesShort(fileInfoVersionTypeHolder.getFileInfo().getSize());
                    this.setHorizontalAlignment(4);
                }
            }
            Component component = super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            ((JLabel)component).setToolTipText(string2);
            if (!bl) {
                this.setBackground(n % 2 == 0 ? ColorUtil.EVEN_TABLE_ROW_COLOR : ColorUtil.ODD_TABLE_ROW_COLOR);
            }
            return component;
        }
    }

    private class TableHeaderMouseListener
    extends MouseAdapter {
        private TableHeaderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                FileVersionsTableModel fileVersionsTableModel;
                boolean bl;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n);
                int n2 = tableColumn.getModelIndex();
                TableModel tableModel = jTableHeader.getTable().getModel();
                if (tableModel instanceof FileVersionsTableModel && !(bl = (fileVersionsTableModel = (FileVersionsTableModel)tableModel).sortBy(n2))) {
                    fileVersionsTableModel.reverseList();
                }
            }
        }
    }
}

