/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.downloads;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.event.TransferManagerAdapter;
import de.dal33t.powerfolder.event.TransferManagerEvent;
import de.dal33t.powerfolder.transfer.Download;
import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.transfer.TransferProblem;
import de.dal33t.powerfolder.ui.model.SortedTableModel;
import de.dal33t.powerfolder.ui.model.TransferManagerModel;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.compare.DownloadManagerComparator;
import de.dal33t.powerfolder.util.compare.ReverseComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class DownloadManagersTableModel
extends PFComponent
implements TableModel,
SortedTableModel {
    public static final int COLTYPE = 0;
    public static final int COLFILE = 1;
    public static final int COLPROGRESS = 2;
    public static final int COLSIZE = 3;
    public static final int COLFOLDER = 4;
    public static final int COLFROM = 5;
    private static final int UPDATE_TIME = 1000;
    private final Collection<TableModelListener> listeners;
    private final List<DownloadManager> downloadManagers;
    private int fileInfoComparatorType = -1;
    private boolean sortAscending = true;
    private volatile boolean dirty;
    private int sortColumn;
    private final TransferManagerModel model;
    private volatile boolean periodicUpdate;

    public DownloadManagersTableModel(TransferManagerModel transferManagerModel) {
        super(transferManagerModel.getController());
        this.model = transferManagerModel;
        Reject.ifNull(transferManagerModel, "Model is null");
        this.listeners = new LinkedList<TableModelListener>();
        this.downloadManagers = new ArrayList<DownloadManager>();
        transferManagerModel.getTransferManager().addListener(new MyTransferManagerListener());
        this.periodicUpdate = false;
        MyTimerTask myTimerTask = new MyTimerTask();
        this.getController().scheduleAndRepeat(myTimerTask, 1000L);
    }

    public void initialize() {
        TransferManager transferManager = this.model.getTransferManager();
        for (DownloadManager downloadManager : transferManager.getCompletedDownloadsCollection()) {
            if (DownloadManagersTableModel.isMetaFolderDownload(downloadManager)) continue;
            this.downloadManagers.add(downloadManager);
        }
        for (DownloadManager downloadManager : transferManager.getActiveDownloads()) {
            if (DownloadManagersTableModel.isMetaFolderDownload(downloadManager)) continue;
            this.downloadManagers.add(downloadManager);
        }
        this.dirty = true;
    }

    private static boolean isMetaFolderDownload(DownloadManager downloadManager) {
        return downloadManager.getFileInfo().getFolderInfo().isMetaFolder();
    }

    public boolean isPeriodicUpdate() {
        return this.periodicUpdate;
    }

    public void setPeriodicUpdate(boolean bl) {
        if (!this.periodicUpdate && bl) {
            this.resortAndUpdate();
        }
        this.periodicUpdate = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadManager getDownloadManagerAtRow(int n) {
        List<DownloadManager> list = this.downloadManagers;
        synchronized (list) {
            if (n >= 0 && n < this.downloadManagers.size()) {
                return this.downloadManagers.get(n);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadManager[] getDownloadManagersAtRows(int[] nArray) {
        DownloadManager[] downloadManagerArray = new DownloadManager[nArray.length];
        List<DownloadManager> list = this.downloadManagers;
        synchronized (list) {
            int n = 0;
            for (int n2 : nArray) {
                if (n2 < this.downloadManagers.size()) {
                    downloadManagerArray[n] = this.downloadManagers.get(n2);
                }
                ++n;
            }
        }
        return downloadManagerArray;
    }

    @Override
    public boolean sortBy(int n) {
        this.sortColumn = n;
        switch (n) {
            case 0: {
                return this.sortMe(0);
            }
            case 1: {
                return this.sortMe(1);
            }
            case 2: {
                return this.sortMe(2);
            }
            case 3: {
                return this.sortMe(3);
            }
            case 4: {
                return this.sortMe(4);
            }
            case 5: {
                return this.sortMe(5);
            }
        }
        this.sortColumn = -1;
        return false;
    }

    public boolean sortMe(int n) {
        boolean bl;
        int n2 = this.fileInfoComparatorType;
        this.fileInfoComparatorType = n;
        if (n2 != n && (bl = this.sort())) {
            this.fireModelChanged();
            return true;
        }
        return false;
    }

    private boolean sort() {
        if (this.fileInfoComparatorType != -1) {
            DownloadManagerComparator downloadManagerComparator = new DownloadManagerComparator(this.fileInfoComparatorType);
            if (this.sortAscending) {
                Collections.sort(this.downloadManagers, downloadManagerComparator);
            } else {
                Collections.sort(this.downloadManagers, new ReverseComparator<DownloadManager>(downloadManagerComparator));
            }
            return true;
        }
        return false;
    }

    private void fireModelChanged() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TableModelEvent tableModelEvent = new TableModelEvent(DownloadManagersTableModel.this);
                for (Object e : DownloadManagersTableModel.this.listeners) {
                    TableModelListener tableModelListener = (TableModelListener)e;
                    tableModelListener.tableChanged(tableModelEvent);
                }
            }
        };
        UIUtil.invokeLaterInEDT(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseList() {
        this.sortAscending = !this.sortAscending;
        List<DownloadManager> list = this.downloadManagers;
        synchronized (list) {
            Collections.reverse(this.downloadManagers);
        }
        this.fireModelChanged();
        this.dirty = true;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        return this.downloadManagers.size();
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return Translation.get("general.file");
            }
            case 2: {
                return Translation.get("transfers.progress");
            }
            case 3: {
                return Translation.get("general.size");
            }
            case 4: {
                return Translation.get("general.folder");
            }
            case 5: {
                return Translation.get("transfers.from");
            }
        }
        return null;
    }

    public Class<DownloadManager> getColumnClass(int n) {
        return DownloadManager.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.downloadManagers.size()) {
            this.logSevere("Illegal rowIndex requested. rowIndex " + n + ", downloadManagers " + this.downloadManagers.size());
            return null;
        }
        DownloadManager downloadManager = this.downloadManagers.get(n);
        if (downloadManager == null) {
            this.logSevere("Illegal rowIndex requested. rowIndex " + n + ", downloadManagers " + this.downloadManagers.size());
            return null;
        }
        switch (n2) {
            case 0: 
            case 1: {
                return downloadManager.getFileInfo();
            }
            case 2: {
                return downloadManager;
            }
            case 3: {
                return downloadManager.getFileInfo().getSize();
            }
            case 4: {
                return downloadManager.getFileInfo().getFolderInfo();
            }
            case 5: {
                return downloadManager.getSources();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        throw new IllegalStateException("Unable to set value in DownloadTableModel, not editable");
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    private void rowAdded() {
        TableModelEvent tableModelEvent = new TableModelEvent(this, this.getRowCount(), this.getRowCount(), -1, 1);
        this.modelChanged(tableModelEvent);
    }

    private void rowRemoved(int n) {
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, -1, -1);
        this.modelChanged(tableModelEvent);
    }

    private void rowsUpdated(int n, int n2) {
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n2);
        this.modelChanged(tableModelEvent);
    }

    private void rowsUpdatedAll() {
        this.rowsUpdated(0, this.downloadManagers.size());
    }

    private void modelChanged(final TableModelEvent tableModelEvent) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Collection collection = DownloadManagersTableModel.this.listeners;
                synchronized (collection) {
                    for (TableModelListener tableModelListener : DownloadManagersTableModel.this.listeners) {
                        tableModelListener.tableChanged(tableModelEvent);
                    }
                }
            }
        };
        UIUtil.invokeLaterInEDT(runnable);
    }

    private static boolean shouldShowProblem(TransferProblem transferProblem) {
        return TransferProblem.FILE_NOT_FOUND_EXCEPTION.equals((Object)transferProblem) || TransferProblem.IO_EXCEPTION.equals((Object)transferProblem) || TransferProblem.TEMP_FILE_DELETE.equals((Object)transferProblem) || TransferProblem.TEMP_FILE_OPEN.equals((Object)transferProblem) || TransferProblem.TEMP_FILE_WRITE.equals((Object)transferProblem) || TransferProblem.MD5_ERROR.equals((Object)transferProblem);
    }

    private void removeDownload(Download download, boolean bl) {
        if (download.getFile().getFolderInfo().isMetaFolder() || DownloadManagersTableModel.isMetaFolderDownload(download.getDownloadManager())) {
            return;
        }
        int n = this.downloadManagers.indexOf(download.getDownloadManager());
        if (n >= 0) {
            if (!download.getDownloadManager().hasSources() || bl) {
                this.downloadManagers.remove(n);
                this.rowRemoved(n);
            } else {
                this.rowsUpdated(n, n);
            }
            this.dirty = true;
        } else if (ConfigurationEntry.DOWNLOAD_AUTO_CLEANUP_FREQUENCY.getValueInt(this.getController()) > 0) {
            this.logFine("Unable to remove download from tablemodel, not found: " + download);
        }
    }

    @Override
    public void setAscending(boolean bl) {
        this.sortAscending = bl;
    }

    private void resortAndUpdate() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DownloadManagersTableModel.this.dirty = DownloadManagersTableModel.this.dirty || DownloadManagersTableModel.this.getController().getTransferManager().countActiveDownloads() > 0;
                if (DownloadManagersTableModel.this.dirty) {
                    if (DownloadManagersTableModel.this.fileInfoComparatorType == 2) {
                        DownloadManagersTableModel.this.sort();
                    }
                    DownloadManagersTableModel.this.rowsUpdatedAll();
                }
                DownloadManagersTableModel.this.dirty = false;
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private class MyTransferManagerListener
    extends TransferManagerAdapter {
        private MyTransferManagerListener() {
        }

        @Override
        public void downloadRequested(TransferManagerEvent transferManagerEvent) {
            this.addOrUpdateDownload(transferManagerEvent.getDownload());
        }

        @Override
        public void downloadQueued(TransferManagerEvent transferManagerEvent) {
            this.addOrUpdateDownload(transferManagerEvent.getDownload());
        }

        @Override
        public void downloadStarted(TransferManagerEvent transferManagerEvent) {
            this.addOrUpdateDownload(transferManagerEvent.getDownload());
        }

        @Override
        public void downloadAborted(TransferManagerEvent transferManagerEvent) {
            if (transferManagerEvent.getDownload() == null) {
                return;
            }
            if (transferManagerEvent.getDownload().isCompleted()) {
                return;
            }
            DownloadManagersTableModel.this.removeDownload(transferManagerEvent.getDownload(), false);
        }

        @Override
        public void downloadBroken(TransferManagerEvent transferManagerEvent) {
            if (transferManagerEvent.getDownload() == null) {
                return;
            }
            if (transferManagerEvent.getDownload().isCompleted()) {
                return;
            }
            if (DownloadManagersTableModel.shouldShowProblem(transferManagerEvent.getDownload().getTransferProblem())) {
                this.addOrUpdateDownload(transferManagerEvent.getDownload());
            } else if (transferManagerEvent.getDownload().isRequestedAutomatic()) {
                DownloadManagersTableModel.this.removeDownload(transferManagerEvent.getDownload(), false);
            }
        }

        @Override
        public void downloadCompleted(TransferManagerEvent transferManagerEvent) {
            this.addOrUpdateDownload(transferManagerEvent.getDownload());
        }

        @Override
        public void completedDownloadRemoved(TransferManagerEvent transferManagerEvent) {
            DownloadManagersTableModel.this.removeDownload(transferManagerEvent.getDownload(), true);
        }

        @Override
        public void pendingDownloadEnqueued(TransferManagerEvent transferManagerEvent) {
        }

        private int findDownloadIndex(Download download) {
            return DownloadManagersTableModel.this.downloadManagers.indexOf(download.getDownloadManager());
        }

        private void addOrUpdateDownload(Download download) {
            DownloadManager downloadManager;
            if (DownloadManagersTableModel.isMetaFolderDownload(download.getDownloadManager())) {
                return;
            }
            int n = this.findDownloadIndex(download);
            DownloadManager downloadManager2 = downloadManager = n >= 0 ? (DownloadManager)DownloadManagersTableModel.this.downloadManagers.get(n) : null;
            if (downloadManager == null) {
                DownloadManagersTableModel.this.downloadManagers.add(download.getDownloadManager());
                DownloadManagersTableModel.this.rowAdded();
            } else {
                DownloadManagersTableModel.this.rowsUpdated(n, n);
            }
            DownloadManagersTableModel.this.dirty = true;
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyTimerTask
    extends TimerTask {
        private MyTimerTask() {
        }

        @Override
        public void run() {
            if (!DownloadManagersTableModel.this.periodicUpdate) {
                return;
            }
            DownloadManagersTableModel.this.resortAndUpdate();
        }
    }
}

