/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.downloads;

import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.ui.information.downloads.DownloadManagersTableModel;
import de.dal33t.powerfolder.ui.model.TransferManagerModel;
import de.dal33t.powerfolder.ui.render.DownloadManagerTableCellRenderer;
import de.dal33t.powerfolder.ui.render.SortedTableHeaderRenderer;
import de.dal33t.powerfolder.ui.util.Icons;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class DownloadManagersTable
extends JTable {
    public DownloadManagersTable(TransferManagerModel transferManagerModel) {
        super(transferManagerModel.getDownloadsTableModel());
        this.setRowHeight(Icons.getIconById("node_friend_connected.icon").getIconHeight() + 3);
        this.setColumnSelectionAllowed(false);
        this.setShowGrid(false);
        DownloadManagerTableCellRenderer downloadManagerTableCellRenderer = new DownloadManagerTableCellRenderer(transferManagerModel.getController());
        this.setDefaultRenderer(DownloadManager.class, downloadManagerTableCellRenderer);
        this.setupColumns();
        SortedTableHeaderRenderer.associateHeaderRenderer(transferManagerModel.getDownloadsTableModel(), this.getColumnModel(), 2, true);
        this.addHierarchyListener(new MyDisplayabilityListener());
    }

    private void setupColumns() {
        int n = this.getWidth();
        this.getTableHeader().setPreferredSize(new Dimension(n, 20));
        TableColumn tableColumn = this.getColumn(this.getColumnName(0));
        tableColumn.setPreferredWidth(20);
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(20);
        tableColumn = this.getColumn(this.getColumnName(1));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.getColumn(this.getColumnName(2));
        tableColumn.setPreferredWidth(80);
        tableColumn = this.getColumn(this.getColumnName(3));
        tableColumn.setPreferredWidth(20);
        tableColumn = this.getColumn(this.getColumnName(4));
        tableColumn.setPreferredWidth(40);
        tableColumn = this.getColumn(this.getColumnName(5));
        tableColumn.setPreferredWidth(20);
    }

    private class MyDisplayabilityListener
    implements HierarchyListener {
        private MyDisplayabilityListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 2L) == 2L) {
                boolean bl = hierarchyEvent.getChanged().isShowing();
                DownloadManagersTableModel downloadManagersTableModel = (DownloadManagersTableModel)DownloadManagersTable.this.getModel();
                downloadManagersTableModel.setPeriodicUpdate(bl);
            }
        }
    }
}

