/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.debug;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.information.InformationCard;
import de.dal33t.powerfolder.ui.information.InformationCardType;
import de.dal33t.powerfolder.ui.information.debug.TextPanel;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.Debug;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.logging.LoggingManager;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DebugInformationCard
extends InformationCard {
    private JPanel uiComponent;
    private TextPanel textPanel;
    private JButton openDebugDir;
    private JButton dumpThreads;
    private JComboBox<Level> logLevelCombo;
    private JCheckBox logToFileCheckBox;
    private JCheckBox scrollLockCheckBox;

    public DebugInformationCard(Controller controller) {
        super(controller);
    }

    @Override
    public InformationCardType getInformationCardType() {
        return InformationCardType.DEBUG;
    }

    @Override
    public Image getCardImage() {
        return Icons.getImageById("bug.icon");
    }

    @Override
    public String getCardTitle() {
        return Translation.get("debug_information_card.title");
    }

    @Override
    public JComponent getUIComponent() {
        if (this.uiComponent == null) {
            this.initialize();
            this.buildUIComponent();
        }
        return this.uiComponent;
    }

    private void initialize() {
        this.textPanel = new TextPanel();
        this.textPanel.setText(LoggingManager.getLogBuffer(), true);
        this.logLevelCombo = new JComboBox();
        this.logLevelCombo.addItem(Level.OFF);
        this.logLevelCombo.addItem(Level.SEVERE);
        this.logLevelCombo.addItem(Level.WARNING);
        this.logLevelCombo.addItem(Level.INFO);
        this.logLevelCombo.addItem(Level.FINE);
        this.logLevelCombo.addItem(Level.FINER);
        this.logLevelCombo.setSelectedItem(LoggingManager.getDocumentLoggingLevel());
        this.logToFileCheckBox = new JCheckBox("Write log files");
        this.scrollLockCheckBox = new JCheckBox("Scroll lock");
        this.updateBoxes();
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getSource() == DebugInformationCard.this.logLevelCombo) {
                    Level level = (Level)DebugInformationCard.this.logLevelCombo.getSelectedItem();
                    LoggingManager.setDocumentLogging(level, DebugInformationCard.this.getController());
                    ConfigurationEntry.LOG_LEVEL_FILE.setValue(DebugInformationCard.this.getController(), level.getName());
                    LoggingManager.setFileLogging(level, ConfigurationEntry.LOG_FILE_ROTATE.getValueBoolean(DebugInformationCard.this.getController()));
                    LoggingManager.resetFileLogging();
                    DebugInformationCard.this.getController().saveConfig();
                } else if (itemEvent.getSource() == DebugInformationCard.this.logToFileCheckBox) {
                    if (DebugInformationCard.this.logToFileCheckBox.isSelected()) {
                        Level level = LoggingManager.getDocumentLoggingLevel();
                        ConfigurationEntry.LOG_LEVEL_FILE.setValue(DebugInformationCard.this.getController(), level.getName());
                        LoggingManager.setFileLogging(level, ConfigurationEntry.LOG_FILE_ROTATE.getValueBoolean(DebugInformationCard.this.getController()));
                        LoggingManager.resetFileLogging();
                        DebugInformationCard.this.getController().saveConfig();
                    }
                } else if (itemEvent.getSource() == DebugInformationCard.this.scrollLockCheckBox) {
                    DebugInformationCard.this.textPanel.setAutoScroll(!DebugInformationCard.this.scrollLockCheckBox.isSelected());
                }
            }
        };
        this.logLevelCombo.addItemListener(itemListener);
        this.logToFileCheckBox.addItemListener(itemListener);
        this.scrollLockCheckBox.addItemListener(itemListener);
        this.openDebugDir = new JButton("Open Logs");
        this.openDebugDir.setEnabled(true);
        this.openDebugDir.setToolTipText("Send log files to Support Team");
        this.dumpThreads = new JButton("CPU dump");
        this.dumpThreads.setToolTipText("Dumps the current CPU activity to logs");
        this.openDebugDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        PathUtils.openFile(LoggingManager.getDebugDir());
                        BrowserLauncher.openURL(DebugInformationCard.this.getController(), ConfigurationEntry.PROVIDER_SUPPORT_FILE_TICKET_URL.getValue(DebugInformationCard.this.getController()));
                    }
                };
                DebugInformationCard.this.getController().getIOProvider().startIO(runnable);
            }
        });
        this.dumpThreads.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                if (((Level)DebugInformationCard.this.logLevelCombo.getSelectedItem()).intValue() > Level.INFO.intValue()) {
                    DebugInformationCard.this.logLevelCombo.setSelectedItem(Level.INFO);
                }
                if (StringUtils.isNotBlank(string = Debug.dumpCurrentStacktraces(false))) {
                    DebugInformationCard.this.logInfo("Active threads:\n\n" + string);
                } else if (DebugInformationCard.this.isInfo()) {
                    DebugInformationCard.this.logInfo("No threads active");
                }
            }
        });
    }

    private void updateBoxes() {
        this.logToFileCheckBox.setSelected(LoggingManager.isLogToFile());
        this.scrollLockCheckBox.setSelected(!this.textPanel.isAutoScroll());
    }

    public void buildUIComponent() {
        FormLayout formLayout = new FormLayout("3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 8dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:pref:grow", "3dlu, pref, 3dlu, fill:pref:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.createToolBar(), cellConstraints.xywh(2, 2, 23, 1));
        panelBuilder.add((Component)this.textPanel.getUIComponent(), cellConstraints.xywh(1, 4, 24, 1));
        this.uiComponent = panelBuilder.getPanel();
    }

    private JPanel createToolBar() {
        ButtonBarBuilder buttonBarBuilder = ButtonBarBuilder.createLeftToRightBuilder();
        buttonBarBuilder.addFixed(this.openDebugDir);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed(new JLabel("Level"));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed(this.logLevelCombo);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed(this.logToFileCheckBox);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed(this.scrollLockCheckBox);
        buttonBarBuilder.addUnrelatedGap();
        buttonBarBuilder.addFixed(this.dumpThreads);
        return buttonBarBuilder.getPanel();
    }
}

