/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.iconoverlay;

import com.liferay.nativity.control.win.WindowsNativityUtil;
import com.liferay.nativity.modules.fileicon.FileIconControl;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.event.FolderEvent;
import de.dal33t.powerfolder.event.FolderListener;
import de.dal33t.powerfolder.event.FolderRepositoryEvent;
import de.dal33t.powerfolder.event.FolderRepositoryListener;
import de.dal33t.powerfolder.event.LockingEvent;
import de.dal33t.powerfolder.event.LockingListener;
import de.dal33t.powerfolder.event.TransferManagerEvent;
import de.dal33t.powerfolder.event.TransferManagerListener;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.ui.iconoverlay.IconOverlayHandler;
import de.dal33t.powerfolder.util.UserDirectories;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class IconOverlayUpdateListener
extends PFComponent
implements LockingListener,
TransferManagerListener,
FolderListener,
FolderRepositoryListener {
    private final FileIconControl iconControl;
    private final IconOverlayHandler overlayHandler;
    private AtomicBoolean updateRunning = new AtomicBoolean(false);
    private Map<FileInfo, FileInfo> dirtyFiles;

    public IconOverlayUpdateListener(Controller controller, FileIconControl fileIconControl, IconOverlayHandler iconOverlayHandler) {
        super(controller);
        this.iconControl = fileIconControl;
        this.overlayHandler = iconOverlayHandler;
        this.dirtyFiles = Util.createConcurrentHashMap();
    }

    @Override
    public boolean fireInEventDispatchThread() {
        return false;
    }

    @Override
    public void downloadRequested(TransferManagerEvent transferManagerEvent) {
        this.update(transferManagerEvent.getFile());
    }

    @Override
    public void downloadQueued(TransferManagerEvent transferManagerEvent) {
        this.update(transferManagerEvent.getFile());
    }

    @Override
    public void downloadStarted(TransferManagerEvent transferManagerEvent) {
        this.update(transferManagerEvent.getFile());
    }

    @Override
    public void downloadAborted(TransferManagerEvent transferManagerEvent) {
        this.update(transferManagerEvent.getFile());
    }

    @Override
    public void downloadBroken(TransferManagerEvent transferManagerEvent) {
        this.update(transferManagerEvent.getFile());
    }

    @Override
    public void downloadCompleted(TransferManagerEvent transferManagerEvent) {
        this.update(transferManagerEvent.getFile());
    }

    @Override
    public void completedDownloadRemoved(TransferManagerEvent transferManagerEvent) {
        this.update(transferManagerEvent.getFile());
    }

    @Override
    public void pendingDownloadEnqueued(TransferManagerEvent transferManagerEvent) {
        this.update(transferManagerEvent.getFile());
    }

    @Override
    public void uploadRequested(TransferManagerEvent transferManagerEvent) {
        this.update(transferManagerEvent.getFile());
    }

    @Override
    public void uploadStarted(TransferManagerEvent transferManagerEvent) {
        this.update(transferManagerEvent.getFile());
    }

    @Override
    public void uploadAborted(TransferManagerEvent transferManagerEvent) {
        this.update(transferManagerEvent.getFile());
    }

    @Override
    public void uploadBroken(TransferManagerEvent transferManagerEvent) {
        this.update(transferManagerEvent.getFile());
    }

    @Override
    public void uploadCompleted(TransferManagerEvent transferManagerEvent) {
        this.update(transferManagerEvent.getFile());
    }

    @Override
    public void completedUploadRemoved(TransferManagerEvent transferManagerEvent) {
        this.update(transferManagerEvent.getFile());
    }

    @Override
    public void locked(LockingEvent lockingEvent) {
        this.update(lockingEvent.getFileInfo());
    }

    @Override
    public void unlocked(LockingEvent lockingEvent) {
        this.update(lockingEvent.getFileInfo());
    }

    @Override
    public void autoLockForbidden(LockingEvent lockingEvent) {
        this.update(lockingEvent.getFileInfo());
    }

    private void update(FileInfo fileInfo) {
        if (fileInfo.getFolder(this.getController().getFolderRepository()) == null) {
            return;
        }
        this.dirtyFiles.put(fileInfo, fileInfo);
        if (!this.updateRunning.compareAndSet(false, true)) {
            if (this.isFiner()) {
                this.logFiner("Not spawning, already running update");
            }
            return;
        }
        this.getController().getIOProvider().startIO(() -> {
            while (!this.dirtyFiles.isEmpty()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    this.updateRunning.set(false);
                    return;
                }
                if (this.isFine()) {
                    this.logFine("Updating OS file exporer for files: " + this.dirtyFiles.size() + ": " + this.dirtyFiles);
                }
                for (FileInfo fileInfo : this.dirtyFiles.keySet()) {
                    this.dirtyFiles.remove(fileInfo);
                    Path path = fileInfo.getDiskFile(this.getController().getFolderRepository());
                    if (path == null) continue;
                    try {
                        if (!Files.exists(path, new LinkOption[0])) continue;
                        String string = path.toString();
                        if (OSUtil.isWindowsSystem()) {
                            WindowsNativityUtil.updateExplorer(string);
                            continue;
                        }
                        if (!OSUtil.isMacOS()) continue;
                        this.iconControl.setFileIcon(string, this.overlayHandler.getIconForFile(fileInfo));
                    }
                    catch (RuntimeException runtimeException) {
                        this.logFine("Caught exception while updating single file " + fileInfo.toDetailString() + ". " + runtimeException, runtimeException);
                    }
                }
            }
            this.updateRunning.set(false);
        });
    }

    private void updateFolder(Folder folder) {
        if (OSUtil.isWindowsSystem()) {
            this.getController().getIOProvider().startIO(() -> {
                try {
                    if (!folder.getLocalBase().toString().equals(UserDirectories.getDocumentsReported())) {
                        WindowsNativityUtil.updateExplorer(folder.getLocalBase().toString());
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.logFine("Caught exception while updating folder " + folder + ". " + runtimeException, runtimeException);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.logFine("Caught exception while updating folder " + folder + ". " + unsatisfiedLinkError, unsatisfiedLinkError);
                }
            });
        }
    }

    @Override
    public void folderRemoved(FolderRepositoryEvent folderRepositoryEvent) {
        folderRepositoryEvent.getFolder().removeFolderListener(this);
    }

    @Override
    public void folderCreated(FolderRepositoryEvent folderRepositoryEvent) {
        folderRepositoryEvent.getFolder().addFolderListener(this);
    }

    @Override
    public void folderMoved(FolderRepositoryEvent folderRepositoryEvent) {
        folderRepositoryEvent.getOldFolder().removeFolderListener(this);
        folderRepositoryEvent.getFolder().addFolderListener(this);
    }

    @Override
    public void maintenanceStarted(FolderRepositoryEvent folderRepositoryEvent) {
    }

    @Override
    public void maintenanceFinished(FolderRepositoryEvent folderRepositoryEvent) {
    }

    @Override
    public void cleanupStarted(FolderRepositoryEvent folderRepositoryEvent) {
    }

    @Override
    public void cleanupFinished(FolderRepositoryEvent folderRepositoryEvent) {
    }

    @Override
    public void statisticsCalculated(FolderEvent folderEvent) {
        this.updateFolder(folderEvent.getFolder());
    }

    @Override
    public void syncProfileChanged(FolderEvent folderEvent) {
    }

    @Override
    public void archiveSettingsChanged(FolderEvent folderEvent) {
    }

    @Override
    public void archivePurged(FolderEvent folderEvent) {
    }

    @Override
    public void remoteContentsChanged(FolderEvent folderEvent) {
    }

    @Override
    public void scanResultCommitted(FolderEvent folderEvent) {
        if (folderEvent.getScanResult().isChangeDetected()) {
            this.updateFolder(folderEvent.getFolder());
        }
    }

    @Override
    public void fileChanged(FolderEvent folderEvent) {
    }

    @Override
    public void filesDeleted(FolderEvent folderEvent) {
    }
}

