/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.friends;

import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.net.NodeSearcher;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.action.ConnectAction;
import de.dal33t.powerfolder.ui.friends.FindComputersTable;
import de.dal33t.powerfolder.ui.model.SearchNodeTableModel;
import de.dal33t.powerfolder.ui.util.PopupMenuOpener;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.widget.FilterTextField;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetSocketAddress;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FindComputersPanel
extends PFUIComponent {
    private FilterTextField searchInput;
    private ValueModel searchInputVM;
    private JTable searchResultTable;
    private JScrollPane searchResultScroller;
    private SearchNodeTableModel searchNodeTableModel;
    private JComponent panel;
    private Action addFriendAction = new AddFriendAction();
    private Action connectAction;
    private NodeSearcher searcher;
    private JLabel noResultsLabel;
    private JCheckBox hideOffline;

    public FindComputersPanel(Controller controller) {
        super(controller);
        this.connectAction = new MyConnectAction(controller);
        this.noResultsLabel = new JLabel(Translation.get("exp.friend_search.no_computers_found"), 0);
        this.noResultsLabel.setEnabled(false);
    }

    private void showResults(final Boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FindComputersPanel.this.searchResultScroller.setVisible(bl);
                FindComputersPanel.this.noResultsLabel.setVisible(bl == false);
            }
        });
    }

    public JComponent getUIComponent() {
        if (this.panel == null) {
            this.initComponents();
            this.panel = this.createContentPanel();
            this.searchInput.requestFocus();
            this.showResults(false);
        }
        return this.panel;
    }

    public void cancelSearch() {
        if (this.searcher != null && this.searcher.isSearching()) {
            this.searcher.cancelSearch();
        }
    }

    private void initComponents() {
        this.searchInput = new FilterTextField(15, Translation.get("exp.find_computers_panel.search_for_computer.hint"), Translation.get("exp.find_computers_panel.search_for_computer.tooltip"));
        this.searchInputVM = this.searchInput.getValueModel();
        this.searchInputVM.addValueChangeListener(new MySearchInputVMListener());
        this.searchNodeTableModel = new SearchNodeTableModel(this.getController());
        this.addFriendAction.setEnabled(false);
        this.searchResultTable = new FindComputersTable(this.searchNodeTableModel);
        this.searchResultTable.getSelectionModel().addListSelectionListener(new SearchResultSelectionListener());
        this.searchResultTable.addMouseListener(new PopupMenuOpener(this.createPopupMenu()));
        this.searchResultTable.addMouseListener(new DoubleClickAction(this.addFriendAction));
        this.searchResultTable.registerKeyboardAction(new SelectAllAction(), KeyStroke.getKeyStroke(65, 2), 0);
        this.searchResultScroller = new JScrollPane(this.searchResultTable);
        UIUtil.whiteStripTable(this.searchResultTable);
        UIUtil.removeBorder(this.searchResultScroller);
        this.searchNodeTableModel.getListModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                FindComputersPanel.this.showResults(!FindComputersPanel.this.searchNodeTableModel.getListModel().isEmpty());
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                FindComputersPanel.this.showResults(!FindComputersPanel.this.searchNodeTableModel.getListModel().isEmpty());
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                FindComputersPanel.this.showResults(!FindComputersPanel.this.searchNodeTableModel.getListModel().isEmpty());
            }
        });
    }

    private JComponent createContentPanel() {
        FormLayout formLayout = new FormLayout("fill:600:grow", "pref, 3dlu, pref, 3dlu, fill:300:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.createSearchPanel(), cellConstraints.xy(1, 1));
        panelBuilder.addSeparator(null, cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.searchResultScroller, cellConstraints.xy(1, 5));
        panelBuilder.add((Component)this.noResultsLabel, cellConstraints.xy(1, 5));
        this.updateActions();
        return panelBuilder.getPanel();
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = SimpleComponentFactory.createPopupMenu();
        jPopupMenu.add(this.addFriendAction);
        return jPopupMenu;
    }

    private JPanel createSearchPanel() {
        this.hideOffline = new JCheckBox(new HideOfflineAction());
        this.hideOffline.setSelected(PreferencesEntry.FRIEND_SEARCH_HIDE_OFFLINE.getValueBoolean(this.getController()));
        this.hideOffline.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PreferencesEntry.FRIEND_SEARCH_HIDE_OFFLINE.setValue(FindComputersPanel.this.getController(), FindComputersPanel.this.hideOffline.isSelected());
            }
        });
        FormLayout formLayout = new FormLayout("0:grow, pref, 3dlu, pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.hideOffline, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.searchInput.getUIComponent(), cellConstraints.xy(4, 1));
        return panelBuilder.getPanel();
    }

    private void search() {
        Object object = this.searchInputVM.getValue();
        if (object == null) {
            return;
        }
        String string = ((String)object).trim().toLowerCase();
        if (string.length() < 3) {
            return;
        }
        this.cancelSearch();
        this.searcher = new NodeSearcher(this.getController(), string, this.searchNodeTableModel.getListModel(), false, this.hideOffline.isSelected());
        this.searcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFriend() {
        SearchNodeTableModel searchNodeTableModel = this.searchNodeTableModel;
        synchronized (searchNodeTableModel) {
            int[] nArray = this.searchResultTable.getSelectedRows();
            if (nArray != null && nArray.length > 0) {
                for (int n : nArray) {
                    Object object = this.searchNodeTableModel.getDataAt(n);
                    if (!(object instanceof Member)) continue;
                    Member member = (Member)object;
                    member.setFriend(true, null);
                }
            }
        }
        this.updateActions();
        this.search();
    }

    private void updateActions() {
        this.addFriendAction.setEnabled(false);
        int[] nArray = this.searchResultTable.getSelectedRows();
        boolean bl = false;
        for (int n : nArray) {
            Member member;
            Object object = this.searchNodeTableModel.getDataAt(n);
            if (!(object instanceof Member) || (member = (Member)object).isFriend()) continue;
            bl = true;
            break;
        }
        this.addFriendAction.setEnabled(bl);
    }

    public Action getAddFriendAction() {
        return this.addFriendAction;
    }

    public Action getConnectAction() {
        return this.connectAction;
    }

    private class AddFriendAction
    extends BaseAction {
        private AddFriendAction() {
            super("action_add_friend", FindComputersPanel.this.getController());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindComputersPanel.this.addFriend();
        }
    }

    private class MyConnectAction
    extends ConnectAction {
        private MyConnectAction(Controller controller) {
            super(controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Member member;
            int n = FindComputersPanel.this.searchResultTable.getSelectedRow();
            if (n >= 0 && (member = (Member)FindComputersPanel.this.searchNodeTableModel.getValueAt(n, 0)) != null) {
                InetSocketAddress inetSocketAddress = member.getReconnectAddress();
                Object object = inetSocketAddress.getAddress().getHostAddress();
                if (inetSocketAddress.getPort() != 1337) {
                    object = (String)object + ":";
                    object = (String)object + inetSocketAddress.getPort();
                }
                this.setInputConnect((String)object);
            }
            super.actionPerformed(actionEvent);
        }
    }

    private class MySearchInputVMListener
    implements PropertyChangeListener {
        private MySearchInputVMListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FindComputersPanel.this.search();
        }
    }

    private class SearchResultSelectionListener
    implements ListSelectionListener {
        private SearchResultSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            FindComputersPanel.this.updateActions();
        }
    }

    private static class DoubleClickAction
    extends MouseAdapter {
        private Action action;

        DoubleClickAction(Action action) {
            if (action == null) {
                throw new NullPointerException("Action is null");
            }
            this.action = action;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && this.action.isEnabled()) {
                this.action.actionPerformed(null);
            }
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        private SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindComputersPanel.this.searchResultTable.selectAll();
        }
    }

    private class HideOfflineAction
    extends BaseAction {
        private HideOfflineAction() {
            super("exp.action_hide_offline", FindComputersPanel.this.getController());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindComputersPanel.this.search();
        }
    }
}

