/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog.directory;

import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.dialog.BaseDialog;
import de.dal33t.powerfolder.ui.util.LinkedTextBuilder;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

class NewDirectoryCreator
extends BaseDialog {
    private String baseDirectory;
    private final JTextField subdirField;
    private final ValueModel valueModel;
    private JButton okButton;

    NewDirectoryCreator(Controller controller, boolean bl, String string, ValueModel valueModel) {
        super(BaseDialog.Senior.NONE, controller, bl);
        this.baseDirectory = string;
        this.subdirField = new JTextField();
        this.valueModel = valueModel;
    }

    @Override
    protected Component getButtonBar() {
        this.okButton = NewDirectoryCreator.createOKButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewDirectoryCreator.this.valueModel.setValue(NewDirectoryCreator.this.subdirField.getText());
                NewDirectoryCreator.this.close();
            }
        });
        JButton jButton = NewDirectoryCreator.createCancelButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewDirectoryCreator.this.close();
            }
        });
        return ButtonBarFactory.buildCenteredBar(this.okButton, jButton);
    }

    @Override
    protected JButton getDefaultButton() {
        return this.okButton;
    }

    @Override
    protected JComponent getContent() {
        FormLayout formLayout = new FormLayout("pref, 4dlu, pref:grow", "pref, 4dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)LinkedTextBuilder.build(this.getController(), Translation.get("dialog.new-directory-creator.text", this.baseDirectory)).getPanel(), cellConstraints.xyw(1, 1, 3));
        panelBuilder.add((Component)new JLabel(Translation.get("general.directory")), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.subdirField, cellConstraints.xy(3, 3));
        return panelBuilder.getPanel();
    }

    @Override
    protected Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return Translation.get("dialog.new-directory-creator.title");
    }
}

