/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog.directory;

import de.dal33t.powerfolder.ui.dialog.directory.DirectoryTreeNode;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.StringUtils;
import java.awt.Component;
import java.nio.file.Path;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class DirectoryTreeCellRenderer
extends DefaultTreeCellRenderer {
    DirectoryTreeCellRenderer() {
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        Icon icon = null;
        if (object instanceof DirectoryTreeNode) {
            DirectoryTreeNode directoryTreeNode = (DirectoryTreeNode)object;
            Path path = (Path)directoryTreeNode.getUserObject();
            if (path != null) {
                if (directoryTreeNode.isVolume()) {
                    String string = directoryTreeNode.getEnhancedVolumeText();
                    if (StringUtils.isEmpty(string)) {
                        string = path.toAbsolutePath().toString();
                    }
                    this.setText(string);
                } else {
                    this.setText(path.getFileName().toString());
                }
            }
            icon = directoryTreeNode.getIcon();
        }
        if (icon == null) {
            icon = bl2 ? Icons.getIconById("directory_open.icon") : Icons.getIconById("directory.icon");
        }
        this.setIcon(icon);
        return this;
    }
}

