/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.ui.dialog.BaseDialog;
import de.dal33t.powerfolder.ui.widget.ActivityVisualizationWorker;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;

public class SyncFolderDialog
extends BaseDialog {
    private JButton okButton;
    private static final Object SEND_OPTION = new Object();
    private static final Object RECEIVE_OPTION = new Object();
    private static final Object SEND_RECEIVE_OPTION = new Object();
    private Folder folder;
    private JComponent sendChangesButton;
    private JComponent receiveChangesButton;
    private JComponent sendAndReceiveChangesButton;
    private ValueModel optionModel;

    public SyncFolderDialog(Controller controller, Folder folder) {
        super(BaseDialog.Senior.NONE, controller, true);
        this.folder = folder;
    }

    private void performSync() {
        SyncFolderWorker syncFolderWorker = new SyncFolderWorker();
        syncFolderWorker.start();
    }

    @Override
    public String getTitle() {
        return Translation.get("dialog.synchronization.title");
    }

    @Override
    protected Icon getIcon() {
        return null;
    }

    @Override
    protected JComponent getContent() {
        this.initComponents();
        FormLayout formLayout = new FormLayout("pref", "pref, 6dlu, pref, 6dlu, pref, pref, pref, 6dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(Translation.get("dialog.synchronization.choose"), cellConstraints.xy(1, 1));
        panelBuilder.addLabel(this.folder.getName(), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.sendChangesButton, cellConstraints.xy(1, 5));
        panelBuilder.add((Component)this.receiveChangesButton, cellConstraints.xy(1, 6));
        panelBuilder.add((Component)this.sendAndReceiveChangesButton, cellConstraints.xy(1, 7));
        return panelBuilder.getPanel();
    }

    @Override
    protected Component getButtonBar() {
        this.okButton = SyncFolderDialog.createOKButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SyncFolderDialog.this.performSync();
                SyncFolderDialog.this.close();
            }
        });
        JButton jButton = SyncFolderDialog.createCancelButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SyncFolderDialog.this.getController().getUIController().getApplicationModel().getSyncingModel().removeInterestedFolderInfo(SyncFolderDialog.this.folder.getInfo());
                SyncFolderDialog.this.close();
            }
        });
        return ButtonBarFactory.buildCenteredBar(this.okButton, jButton);
    }

    @Override
    protected JButton getDefaultButton() {
        return this.okButton;
    }

    private void initComponents() {
        this.optionModel = new ValueHolder(SEND_RECEIVE_OPTION);
        this.sendChangesButton = BasicComponentFactory.createRadioButton(this.optionModel, SEND_OPTION, Translation.get("dialog.synchronization.send_own_changes"));
        this.receiveChangesButton = BasicComponentFactory.createRadioButton(this.optionModel, RECEIVE_OPTION, Translation.get("dialog.synchronization.receive_changes"));
        this.sendAndReceiveChangesButton = BasicComponentFactory.createRadioButton(this.optionModel, SEND_RECEIVE_OPTION, Translation.get("dialog.synchronization.send_and_receive_changes"));
    }

    private final class SyncFolderWorker
    extends ActivityVisualizationWorker {
        private SyncFolderWorker() {
            super(SyncFolderDialog.this.getUIController());
        }

        @Override
        protected String getTitle() {
            return Translation.get("dialog.synchronization.sychronizing");
        }

        @Override
        protected String getWorkingText() {
            return Translation.get("dialog.synchronization.sychronizing");
        }

        @Override
        public Object construct() {
            if (SyncFolderDialog.this.optionModel.getValue() == SEND_OPTION || SyncFolderDialog.this.optionModel.getValue() == SEND_RECEIVE_OPTION) {
                SyncFolderDialog.this.logInfo(SyncFolderDialog.this.folder + ": Performing send/scan");
                SyncFolderDialog.this.folder.scanLocalFiles();
            }
            if (SyncFolderDialog.this.optionModel.getValue() == RECEIVE_OPTION || SyncFolderDialog.this.optionModel.getValue() == SEND_RECEIVE_OPTION) {
                SyncFolderDialog.this.logInfo(SyncFolderDialog.this.folder + ": Performing receive");
                SyncFolderDialog.this.folder.syncRemoteDeletedFiles(true);
                SyncFolderDialog.this.getController().getFolderRepository().getFileRequestor().requestMissingFiles(SyncFolderDialog.this.folder, false);
            }
            return null;
        }
    }
}

