/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.BaseDialog;
import de.dal33t.powerfolder.ui.dialog.NodesSelectDialog;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SingleFileTransferDialog
extends BaseDialog {
    private JButton transferButton;
    private JButton cancelButton;
    private Path file;
    private JTextField computersText;
    private JButton computersSelectButton;
    private ValueModel computersTextModel;
    private final Collection<Member> computersMembers = new ArrayList<Member>();
    private JTextArea messageTextArea;

    public SingleFileTransferDialog(Controller controller, Path path, Member member) {
        super(BaseDialog.Senior.NONE, controller, true);
        this.file = path;
        if (member != null) {
            this.computersMembers.add(member);
        }
    }

    @Override
    public String getTitle() {
        return Translation.get("dialog.single_file_transfer.title");
    }

    @Override
    protected Component getButtonBar() {
        return ButtonBarFactory.buildCenteredBar(this.transferButton, this.cancelButton);
    }

    @Override
    protected Icon getIcon() {
        return null;
    }

    @Override
    protected JButton getDefaultButton() {
        return this.transferButton;
    }

    @Override
    protected JComponent getContent() {
        Object object;
        this.initComponents();
        FormLayout formLayout = new FormLayout("right:pref, 3dlu, pref", "pref, 3dlu, pref, 3dlu, pref, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)new JLabel(Translation.get("dialog.single_file_transfer.file_name")), cellConstraints.xy(1, 1));
        JTextField jTextField = new JTextField(this.file.toAbsolutePath().toString());
        jTextField.setEnabled(false);
        FormLayout formLayout2 = new FormLayout("140dlu", "pref");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2);
        panelBuilder2.add((Component)jTextField, cellConstraints.xy(1, 1));
        JPanel jPanel = panelBuilder2.getPanel();
        panelBuilder.add((Component)jPanel, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)new JLabel(Translation.get("dialog.single_file_transfer.computer")), cellConstraints.xy(1, 3));
        if (this.computersMembers.isEmpty()) {
            object = new FormLayout("122dlu, 3dlu, pref", "pref");
            PanelBuilder panelBuilder3 = new PanelBuilder((FormLayout)object);
            panelBuilder3.add((Component)this.computersText, cellConstraints.xy(1, 1));
            panelBuilder3.add((Component)this.computersSelectButton, cellConstraints.xy(3, 1));
            JPanel jPanel2 = panelBuilder3.getPanel();
            panelBuilder.add((Component)jPanel2, cellConstraints.xy(3, 3));
        } else {
            object = this.computersMembers.iterator().next();
            JTextField jTextField2 = new JTextField(((Member)object).getInfo().nick);
            jTextField2.setEnabled(false);
            FormLayout formLayout3 = new FormLayout("140dlu", "pref");
            PanelBuilder panelBuilder4 = new PanelBuilder(formLayout3);
            panelBuilder4.add((Component)jTextField2, cellConstraints.xy(1, 1));
            JPanel jPanel3 = panelBuilder4.getPanel();
            panelBuilder.add((Component)jPanel3, cellConstraints.xy(3, 3));
        }
        panelBuilder.add((Component)new JLabel(Translation.get("dialog.single_file_transfer.friend_message.text")), cellConstraints.xyw(1, 5, 3));
        object = new JScrollPane(this.messageTextArea);
        ((JComponent)object).setPreferredSize(new Dimension(400, 200));
        panelBuilder.add((Component)object, cellConstraints.xyw(1, 6, 3));
        return panelBuilder.getPanel();
    }

    private void initComponents() {
        this.cancelButton = SingleFileTransferDialog.createCancelButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingleFileTransferDialog.this.close();
            }
        });
        this.createTransferButton();
        this.computersTextModel = new ValueHolder();
        this.computersTextModel.setValue(Translation.get("dialog.node_select.no_computers"));
        this.computersTextModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SingleFileTransferDialog.this.updateTransferButton();
            }
        });
        this.computersText = BasicComponentFactory.createTextField(this.computersTextModel, false);
        this.computersText.setEnabled(false);
        this.computersSelectButton = new JButtonMini(Icons.getIconById("node_friend_connected.icon"), Translation.get("dialog.single_file_transfer.select_computer.tip"));
        this.computersSelectButton.addActionListener(new MyActionListener());
        this.updateTransferButton();
        this.messageTextArea = new JTextArea();
    }

    private void updateTransferButton() {
        this.transferButton.setEnabled(!this.computersMembers.isEmpty());
    }

    private void createTransferButton() {
        SingleFileTransferAction singleFileTransferAction = new SingleFileTransferAction(this.getController());
        this.transferButton = new JButton(singleFileTransferAction);
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NodesSelectDialog nodesSelectDialog = new NodesSelectDialog(SingleFileTransferDialog.this.getController(), SingleFileTransferDialog.this.computersTextModel, SingleFileTransferDialog.this.computersMembers);
            nodesSelectDialog.open();
        }
    }

    private class SingleFileTransferAction
    extends BaseAction {
        private SingleFileTransferAction(Controller controller) {
            super("action_single_file_transfer", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SingleFileTransferDialog.this.close();
        }
    }
}

