/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class GenericDialog {
    public static final int NO_BUTTON_CLICKED_INDEX = -1;
    private static final Icon INFO_ICON_ICON = UIManager.getIcon("OptionPane.informationIcon");
    private static final Icon WARN_ICON_ICON = UIManager.getIcon("OptionPane.warningIcon");
    private static final Icon ERROR_ICON_ICON = UIManager.getIcon("OptionPane.errorIcon");
    private static final Icon QUESTION_ICON_ICON = UIManager.getIcon("OptionPane.questionIcon");
    private Window parent;
    private boolean neverAskAgainMode;
    private JCheckBox neverAskAgainCheckBox;
    private String title;
    private Icon icon;
    private JPanel innerPanel;
    private int initialSelection;
    private JButton[] buttons;
    private JButton helpButton;
    private ValueModel buttonModel;
    private JDialog dialog;
    private String[] mnemonics;
    private String neverAskAgainMnemonic;

    public GenericDialog(Window window, String string, JPanel jPanel, GenericDialogType genericDialogType, String[] stringArray, int n, String string2, JButton jButton) {
        this.parent = window;
        this.title = string;
        this.innerPanel = jPanel;
        this.initialSelection = n;
        this.helpButton = jButton;
        this.validateArgs(stringArray);
        this.resolveMnemonics(stringArray, string2);
        this.initComponents(string2, genericDialogType, stringArray);
    }

    private void initComponents(String string, GenericDialogType genericDialogType, String[] stringArray) {
        this.buttonModel = new ValueHolder(-1);
        boolean bl = this.neverAskAgainMode = string != null && string.trim().length() > 0;
        if (GenericDialogType.DEFAULT == genericDialogType) {
            this.icon = null;
        } else if (GenericDialogType.INFO == genericDialogType) {
            this.icon = INFO_ICON_ICON;
        } else if (GenericDialogType.WARN == genericDialogType) {
            this.icon = WARN_ICON_ICON;
        } else if (GenericDialogType.ERROR == genericDialogType) {
            this.icon = ERROR_ICON_ICON;
        } else if (GenericDialogType.QUESTION == genericDialogType) {
            this.icon = QUESTION_ICON_ICON;
        } else {
            throw new IllegalArgumentException("Invalid type. Could not find icon for " + genericDialogType);
        }
        this.buttons = new JButton[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = this.mnemonics[i];
            final int n = i;
            AbstractAction abstractAction = new AbstractAction(string2){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GenericDialog.this.buttonModel.setValue(n);
                    GenericDialog.this.dispose();
                }
            };
            JButton jButton = new JButton(abstractAction);
            if (string3 != null && string3.length() > 0) {
                abstractAction.putValue("MnemonicKey", string3.charAt(0));
            }
            this.buttons[i] = jButton;
        }
        if (string != null) {
            this.neverAskAgainCheckBox = new JCheckBox(string);
            if (this.neverAskAgainMnemonic != null) {
                this.neverAskAgainCheckBox.setMnemonic(this.neverAskAgainMnemonic.charAt(0));
            }
        }
    }

    public int display() {
        int n;
        this.dialog = new JDialog(this.parent, this.title, Dialog.ModalityType.APPLICATION_MODAL);
        FormLayout formLayout = new FormLayout("3dlu, pref, 3dlu, pref:grow, 3dlu", "3dlu, pref:grow, 3dlu, pref, 3dlu, pref, 3dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        if (this.icon != null) {
            panelBuilder.add((Component)new JLabel(this.icon), cellConstraints.xy(2, 2, "center, top"));
        }
        panelBuilder.add((Component)this.innerPanel, cellConstraints.xy(4, 2, "center, center"));
        if (this.neverAskAgainCheckBox != null) {
            panelBuilder.add((Component)this.neverAskAgainCheckBox, cellConstraints.xywh(2, 4, 3, 1));
        }
        FormLayout formLayout2 = this.helpButton == null ? new FormLayout("pref", "pref") : new FormLayout("pref, 3dlu, pref", "pref");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2);
        ButtonBarBuilder buttonBarBuilder = ButtonBarBuilder.createLeftToRightBuilder();
        int n2 = 0;
        for (JButton jButton : this.buttons) {
            buttonBarBuilder.addRelatedGap();
            buttonBarBuilder.addGridded(jButton);
            if (this.initialSelection != n2++) continue;
            this.dialog.getRootPane().setDefaultButton(jButton);
        }
        buttonBarBuilder.addRelatedGap();
        panelBuilder2.add((Component)buttonBarBuilder.getPanel(), cellConstraints.xy(1, 1));
        if (this.helpButton != null) {
            panelBuilder2.add((Component)this.helpButton, cellConstraints.xy(3, 1));
        }
        panelBuilder.add((Component)panelBuilder2.getPanel(), cellConstraints.xywh(2, 6, 3, 1, "center, center"));
        this.dialog.getContentPane().add(panelBuilder.getPanel());
        this.dialog.getContentPane().setSize(this.innerPanel.getPreferredSize().width, this.innerPanel.getPreferredSize().height);
        this.dialog.pack();
        if (this.parent != null && this.parent.isVisible()) {
            int n3 = this.parent.getX() + (this.parent.getWidth() - this.dialog.getWidth()) / 2;
            n = this.parent.getY() + (this.parent.getHeight() - this.dialog.getHeight()) / 2;
            this.dialog.setLocation(n3, n);
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            n = (int)(dimension.getWidth() - (double)this.dialog.getWidth()) / 2;
            int n4 = (int)(dimension.getHeight() - (double)this.dialog.getHeight()) / 2;
            this.dialog.setLocation(n, n4);
        }
        this.dialog.setVisible(true);
        return (Integer)this.buttonModel.getValue();
    }

    public boolean isNeverAskAgain() throws IllegalStateException {
        if (!this.neverAskAgainMode) {
            throw new IllegalStateException("You cannot request the NeverAskAgain state for GenericDialogs that did not set neverAskAgainText in the constructor");
        }
        return this.neverAskAgainCheckBox.isSelected();
    }

    private void validateArgs(String[] stringArray) {
        if (this.innerPanel == null) {
            throw new IllegalArgumentException("Expected a innerPanel to display");
        }
        if (this.title == null || this.title.trim().length() == 0) {
            throw new IllegalArgumentException("Expected a title to display");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Missing options");
        }
        if (this.initialSelection < 0 || this.initialSelection >= stringArray.length) {
            throw new IllegalArgumentException("Invalid initialSelection");
        }
    }

    private void dispose() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void resolveMnemonics(String[] stringArray, String string) {
        String string2;
        int n;
        String string3;
        int n2;
        this.mnemonics = new String[stringArray.length];
        block0: for (n2 = 0; n2 < stringArray.length; ++n2) {
            string3 = stringArray[n2];
            for (n = 0; n < string3.length(); ++n) {
                string2 = string3.substring(n, n + 1);
                if (string2.equals(" ") || !string2.toUpperCase().equals(string2) || this.inMnemonics(string2)) continue;
                this.mnemonics[n2] = string2;
                continue block0;
            }
        }
        block2: for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (this.mnemonics[n2] != null) continue;
            string3 = stringArray[n2];
            for (n = 0; n < string3.length(); ++n) {
                string2 = string3.substring(n, n + 1);
                if (string2.equals(" ") || this.inMnemonics(string2)) continue;
                this.mnemonics[n2] = string2;
                continue block2;
            }
        }
        if (string != null && string.trim().length() > 0) {
            for (n2 = 0; n2 < string.length(); ++n2) {
                string3 = string.substring(n2, n2 + 1);
                if (string3.equals(" ") || !string3.toUpperCase().equals(string3) || this.inMnemonics(string3)) continue;
                this.neverAskAgainMnemonic = string3;
                return;
            }
            for (n2 = 0; n2 < string.length(); ++n2) {
                string3 = string.substring(n2, n2 + 1);
                if (string3.equals(" ") || this.inMnemonics(string3)) continue;
                this.neverAskAgainMnemonic = string3;
                return;
            }
        }
    }

    private boolean inMnemonics(String string) {
        for (String string2 : this.mnemonics) {
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }
}

