/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ConnectDialog
extends PFUIComponent {
    private Window owner;
    private JDialog uiComponent;
    private JLabel infoText;
    private boolean canceled;

    public ConnectDialog(Controller controller, Window window) {
        super(controller);
        this.owner = window;
        this.canceled = false;
    }

    private void initComponents() {
        this.uiComponent = new JDialog(this.owner, Translation.get("dialog.connect.connecting"), Dialog.ModalityType.MODELESS);
        this.uiComponent.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ConnectDialog.this.canceled = true;
                ConnectDialog.this.close();
            }
        });
        this.uiComponent.setResizable(false);
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        this.infoText = new JLabel(Translation.get("dialog.connect.connecting"));
        JButton jButton = new JButton(Translation.get("general.cancel"));
        jButton.setMnemonic(Translation.get("general.cancel.key").charAt(0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.canceled = true;
                ConnectDialog.this.close();
            }
        });
        JPanel jPanel = ButtonBarFactory.buildCenteredBar(jButton);
        FormLayout formLayout = new FormLayout("20dlu, max(70dlu;pref):grow, max(70dlu;pref):grow, 20dlu", "pref, 14dlu, pref, 14dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(Borders.DLU14_BORDER);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.infoText, cellConstraints.xywh(1, 1, 4, 1));
        panelBuilder.add((Component)jProgressBar, cellConstraints.xywh(2, 3, 2, 1));
        panelBuilder.add((Component)jPanel, cellConstraints.xywh(2, 5, 2, 1));
        this.uiComponent.getContentPane().add(panelBuilder.getPanel());
        this.uiComponent.pack();
        Window window = this.uiComponent.getOwner();
        if (window != null) {
            int n = window.getX() + (window.getWidth() - this.uiComponent.getWidth()) / 2;
            int n2 = window.getY() + (window.getHeight() - this.uiComponent.getHeight()) / 2;
            this.uiComponent.setLocation(n, n2);
        }
    }

    private JDialog getUIComponent() {
        if (this.uiComponent == null) {
            this.initComponents();
        }
        return this.uiComponent;
    }

    public void setInfoText(String string) {
        this.infoText.setText(string);
    }

    public void open(String string) {
        this.canceled = false;
        this.getUIComponent().setVisible(true);
        this.infoText.setText(Translation.get("dialog.connect.connecting_to", string));
    }

    public void close() {
        this.getUIComponent().setVisible(false);
        this.getUIComponent().dispose();
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

