/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.Validator;
import com.jgoodies.validation.message.SimpleValidationMessage;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import com.jgoodies.validation.view.ValidationResultViewFactory;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.dialog.BaseDialog;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.net.AddressRange;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class AddressEditor
extends BaseDialog {
    private JTextField inputLine;
    private JButton okButton;
    private JButton cancelButton;
    private EditorResult result = EditorResult.CANCEL;
    private ValueModel addressModel;
    private ValidationResultModel validationResultModel = new DefaultValidationResultModel();

    public AddressEditor(Controller controller) {
        this(controller, "");
    }

    public AddressEditor(Controller controller, String string) {
        super(BaseDialog.Senior.NONE, controller, true);
        this.addressModel = new ValueHolder();
        this.addressModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = (String)propertyChangeEvent.getNewValue();
                ValidationResult validationResult = new AddressRangeValidator(string).validate((Object)null);
                AddressEditor.this.validationResultModel.setResult(validationResult);
            }
        });
        this.addressModel.setValue(string);
        OKAction oKAction = new OKAction();
        this.okButton = AddressEditor.createOKButton(oKAction);
        this.cancelButton = AddressEditor.createCancelButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressEditor.this.close();
            }
        });
        this.inputLine = BasicComponentFactory.createTextField(this.addressModel, false);
        this.inputLine.setColumns(40);
        this.inputLine.addActionListener(oKAction);
    }

    @Override
    protected Component getButtonBar() {
        return ButtonBarFactory.buildCenteredBar(this.okButton, this.cancelButton);
    }

    @Override
    protected JComponent getContent() {
        FormLayout formLayout = new FormLayout("pref", "pref, 3dlu, 40dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.inputLine, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)ValidationResultViewFactory.createReportList(this.validationResultModel), cellConstraints.xy(1, 3));
        return panelBuilder.getPanel();
    }

    @Override
    protected JButton getDefaultButton() {
        return this.okButton;
    }

    @Override
    protected Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return Translation.get("addressEditor.title");
    }

    public String getAddressRange() {
        return (String)this.addressModel.getValue();
    }

    public EditorResult getResult() {
        return this.result;
    }

    public static enum EditorResult {
        OK,
        CANCEL;

    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!AddressEditor.this.validationResultModel.getResult().hasMessages()) {
                AddressEditor.this.result = EditorResult.OK;
                AddressEditor.this.close();
            }
        }
    }

    private static class AddressRangeValidator
    implements Validator {
        private String input;

        AddressRangeValidator(String string) {
            this.input = string;
        }

        public ValidationResult validate(Object object) {
            ValidationResult validationResult = new ValidationResult();
            if (!this.isValidRange()) {
                validationResult.add(new SimpleValidationMessage(Translation.get("addressEditor.parse_error"), Severity.WARNING));
            }
            return validationResult;
        }

        private boolean isValidRange() {
            try {
                return AddressRange.parseRange(this.input) != null;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
    }
}

