/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.contextmenu;

import com.liferay.nativity.modules.contextmenu.model.ContextMenuAction;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.SyncStatus;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.ui.contextmenu.ShareFileNotificationHandler;
import de.dal33t.powerfolder.util.Util;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

class ShareLinkAction
extends ContextMenuAction {
    private static final Logger log = Logger.getLogger(ShareLinkAction.class.getName());
    private Controller controller;

    ShareLinkAction(Controller controller) {
        this.controller = controller;
    }

    @Override
    public void onSelection(String[] stringArray) {
        try {
            for (String string : stringArray) {
                Path path = Paths.get(string, new String[0]);
                for (Folder folder : this.controller.getFolderRepository().getFolders()) {
                    if (!path.startsWith(folder.getLocalBase())) continue;
                    final ServerClient serverClient = this.controller.getOSClient();
                    final FileInfo fileInfo = FileInfoFactory.lookupInstance(folder, path);
                    if (SyncStatus.of(this.controller, fileInfo, folder) == SyncStatus.IGNORED) {
                        log.fine("File " + fileInfo + " is ignored. Not trying to create link");
                        continue;
                    }
                    this.controller.getIOProvider().startIO(new Runnable(){

                        @Override
                        public void run() {
                            String string = Util.getClipboardContents();
                            String string2 = serverClient.getFolderService(fileInfo.getFolderInfo()).getFileLink(fileInfo);
                            Util.setClipboardContents(string2);
                            ShareFileNotificationHandler shareFileNotificationHandler = new ShareFileNotificationHandler(ShareLinkAction.this.controller, fileInfo, string);
                            shareFileNotificationHandler.show();
                        }
                    });
                }
            }
        }
        catch (RuntimeException runtimeException) {
            log.log(Level.WARNING, "Problem while trying to share link. " + runtimeException, runtimeException);
        }
    }
}

