/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.contextmenu;

import com.liferay.nativity.modules.contextmenu.model.ContextMenuAction;
import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

abstract class PFContextMenuAction
extends ContextMenuAction {
    private static final Logger log = Logger.getLogger(PFContextMenuAction.class.getName());
    private Controller controller;

    PFContextMenuAction(Controller controller) {
        this.controller = controller;
    }

    @Override
    public abstract void onSelection(String[] var1);

    protected List<FileInfo> getFileInfos(String[] stringArray) {
        ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>();
        for (String string : stringArray) {
            Path path = Paths.get(string, new String[0]);
            for (Folder folder : this.controller.getFolderRepository().getFolders()) {
                if (path.equals(folder.getLocalBase())) {
                    arrayList.add(folder.getBaseDirectoryInfo());
                    continue;
                }
                if (string.contains(Constants.POWERFOLDER_SYSTEM_SUBDIR) || !path.startsWith(folder.getLocalBase())) continue;
                FileInfo fileInfo = FileInfoFactory.lookupInstance(folder, path);
                FileInfo fileInfo2 = folder.getDAO().find(fileInfo, null);
                if (fileInfo2 != null) {
                    arrayList.add(fileInfo2);
                    continue;
                }
                log.fine("No info found for " + path);
            }
        }
        return arrayList;
    }

    protected List<Folder> getFolders(String[] stringArray) {
        ArrayList<Folder> arrayList = new ArrayList<Folder>();
        for (String string : stringArray) {
            Folder folder = null;
            folder = this.controller.getFolderRepository().findContainingFolder(Paths.get(string, new String[0]));
            if (folder == null) continue;
            arrayList.add(folder);
        }
        return arrayList;
    }

    protected Controller getController() {
        return this.controller;
    }
}

