/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.computers;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.computers.ComputersList;
import de.dal33t.powerfolder.ui.model.NodeManagerModel;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ComputersTab
extends PFUIComponent {
    private JPanel uiComponent;
    private ComputersList computersList;
    private JCheckBox showOfflineCB;
    private JScrollPane scrollPane;
    private JLabel emptyLabel = new JLabel(Translation.get("exp.computers_tab.no_computers_available"), 0);

    public ComputersTab(Controller controller) {
        super(controller);
        this.emptyLabel.setEnabled(false);
        this.computersList = new ComputersList(this.getController(), this);
        this.showOfflineCB = new JCheckBox(Translation.get("exp.computers_tab.show_offline"));
        this.showOfflineCB.setToolTipText(Translation.get("exp.computers_tab.show_offline.tip"));
        this.showOfflineCB.addActionListener(new MyActionListener());
        this.showOfflineCB.setSelected(PreferencesEntry.SHOW_OFFLINE.getValueBoolean(this.getController()));
        this.configureNodeManagerModel();
    }

    public JPanel getUIComponent() {
        if (this.uiComponent == null) {
            this.buildUI();
        }
        return this.uiComponent;
    }

    private void buildUI() {
        FormLayout formLayout = new FormLayout("pref:grow", "3dlu, pref, 3dlu, pref, 3dlu, fill:0:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        JPanel jPanel = this.createToolBar();
        panelBuilder.add((Component)jPanel, cellConstraints.xy(1, 2));
        panelBuilder.addSeparator(null, cellConstraints.xy(1, 4));
        this.scrollPane = new JScrollPane(this.computersList.getUIComponent());
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        UIUtil.removeBorder(this.scrollPane);
        panelBuilder.add((Component)this.emptyLabel, cellConstraints.xy(1, 6));
        panelBuilder.add((Component)this.scrollPane, cellConstraints.xy(1, 6));
        this.uiComponent = panelBuilder.getPanel();
        this.updateEmptyLabel();
    }

    public void updateEmptyLabel() {
        if (this.emptyLabel != null) {
            this.emptyLabel.setVisible(this.computersList.isEmpty());
        }
        if (this.scrollPane != null) {
            this.scrollPane.setVisible(!this.computersList.isEmpty());
        }
    }

    private JPanel createToolBar() {
        ActionLabel actionLabel = new ActionLabel(this.getController(), this.getApplicationModel().getActionModel().getFindComputersAction());
        actionLabel.convertToBigLabel();
        FormLayout formLayout = new FormLayout("3dlu, pref, 3dlu:grow, pref, 3dlu", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)actionLabel.getUIComponent(), cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.showOfflineCB, cellConstraints.xy(4, 1));
        return panelBuilder.getPanel();
    }

    private void configureNodeManagerModel() {
        NodeManagerModel nodeManagerModel = this.getUIController().getApplicationModel().getNodeManagerModel();
        nodeManagerModel.getShowOfflineModel().setValue(this.showOfflineCB.isSelected());
        PreferencesEntry.SHOW_OFFLINE.setValue(this.getController(), this.showOfflineCB.isSelected());
    }

    public void populate() {
        this.computersList.populate();
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(ComputersTab.this.showOfflineCB)) {
                ComputersTab.this.configureNodeManagerModel();
            }
        }
    }
}

