/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.ui.UIController;
import de.dal33t.powerfolder.ui.event.SyncStatusEvent;
import de.dal33t.powerfolder.ui.event.SyncStatusListener;
import de.dal33t.powerfolder.ui.notices.SimpleNotificationNotice;
import de.dal33t.powerfolder.ui.util.DelayedUpdater;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.TrayIcon;
import java.io.IOException;
import java.util.TimerTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class TrayIconManager
extends PFComponent {
    private static final long ROTATION_STEP_DELAY = 200L;
    private final UIController uiController;
    private TrayIcon trayIcon;
    private final AtomicInteger atomicAngle = new AtomicInteger();
    private final AtomicBoolean atomicConnectedAndLoggedIn = new AtomicBoolean();
    private final AtomicBoolean atomicSyncing = new AtomicBoolean();
    private final DelayedUpdater iconUpdater;

    public TrayIconManager(UIController uIController) {
        super(uIController.getController());
        this.uiController = uIController;
        if (OSUtil.isLinux()) {
            TrayIconManager.whitelistSystray(this.getController());
        }
        this.iconUpdater = new DelayedUpdater(this.getController());
        Image image = Icons.getImageById(Icons.SYSTRAY_SYNC_COMPLETE);
        if (image == null) {
            this.logSevere("Unable to retrieve default system tray icon. System tray disabled");
            OSUtil.disableSystray();
            return;
        }
        this.trayIcon = new TrayIcon(image);
        this.trayIcon.setImageAutoSize(true);
        this.updateConnectionStatus();
        this.updateIcon(SyncStatusEvent.NOT_STARTED);
        this.getController().getUIController().getApplicationModel().addSyncStatusListener(new SyncStatusListener(){

            @Override
            public void syncStatusChanged(final SyncStatusEvent syncStatusEvent) {
                TrayIconManager.this.iconUpdater.schedule(new Runnable(){

                    @Override
                    public void run() {
                        TrayIconManager.this.updateIcon(syncStatusEvent);
                    }
                });
            }

            @Override
            public boolean fireInEventDispatchThread() {
                return true;
            }
        });
        this.getController().scheduleAndRepeat(new SpinnerTask(), 200L);
    }

    public static void whitelistSystray(Controller controller) {
        ScheduledFuture<?> scheduledFuture = controller.schedule(() -> {
            try {
                Runtime.getRuntime().exec("gsettings set com.canonical.Unity.Panel systray-whitelist \"['all']\"");
            }
            catch (IOException iOException) {
                Logger.getLogger(TrayIconManager.class.getName()).warning("Unable to whitelist application for system tray icon. " + iOException);
            }
        }, 0L);
        try {
            scheduledFuture.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            Logger.getLogger(TrayIconManager.class.getName()).warning("Unable to whitelist application for system tray icon. " + exception);
        }
    }

    public TrayIcon getTrayIcon() {
        return this.trayIcon;
    }

    private void updateConnectionStatus() {
        ServerClient serverClient = this.getController().getOSClient();
        boolean bl = serverClient.isConnected();
        boolean bl2 = serverClient.isLoggedIn();
        if (!PreferencesEntry.SHOW_SYSTEM_NOTIFICATIONS.getValueBoolean(this.getController()).booleanValue()) {
            return;
        }
        if (this.atomicConnectedAndLoggedIn.getAndSet(bl && bl2) != bl && bl2) {
            String string = Translation.get("exp.tray_icon_manager.status_change.title");
            String string2 = bl && bl2 ? Translation.get("exp.tray_icon_manager.status_change.connected") : (!this.getController().getNodeManager().isStarted() ? Translation.get("exp.tray_icon_manager.status_change.disabled") : Translation.get("exp.tray_icon_manager.status_change.connecting"));
            this.uiController.getApplicationModel().getNoticesModel().handleNotice(new SimpleNotificationNotice(string, string2));
        }
    }

    private void updateIcon(SyncStatusEvent syncStatusEvent) {
        Image image;
        if (this.trayIcon == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Translation.get("general.application.name") + " 26.0.100");
        stringBuilder.append(" \n");
        boolean bl = false;
        if (syncStatusEvent.equals((Object)SyncStatusEvent.PAUSED)) {
            image = Icons.getImageById(Icons.SYSTRAY_PAUSE);
            stringBuilder.append(Translation.get("systray.tooltip.paused"));
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.NOT_STARTED)) {
            image = Icons.getImageById(Icons.SYSTRAY_WARNING);
            stringBuilder.append(Translation.get("systray.tooltip.not_started"));
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.NO_FOLDERS)) {
            image = Icons.getImageById(Icons.SYSTRAY_WARNING);
            stringBuilder.append(Translation.get("systray.tooltip.no_folders"));
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.SYNCING)) {
            bl = true;
            image = Icons.getImageById(Icons.SYSTRAY_SYNC_ANIMATION[this.atomicAngle.get()]);
            if (this.trayIcon != null) {
                this.trayIcon.setImage(image);
            }
            stringBuilder.append(Translation.get("systray.tooltip.syncing"));
            double d = this.getController().getUIController().getApplicationModel().getSyncingModel().getOverallSyncPercentage();
            if (d >= 0.0) {
                stringBuilder.append(' ');
                stringBuilder.append(Format.formatDecimal(d) + "%");
            }
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.SYNCHRONIZED)) {
            image = Icons.getImageById(Icons.SYSTRAY_SYNC_COMPLETE);
            stringBuilder.append(Translation.get("systray.tooltip.in_sync"));
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.SYNC_INCOMPLETE)) {
            image = Icons.getImageById(Icons.SYSTRAY_SYNC_INCOMPLETE);
            stringBuilder.append(Translation.get("systray.tooltip.sync_incomplete"));
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.NOT_CONNECTED)) {
            image = Icons.getImageById(Icons.SYSTRAY_SYNC_INCOMPLETE);
            stringBuilder.append(Translation.get("systray.tooltip.not_connected"));
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.LOGGING_IN)) {
            image = Icons.getImageById(Icons.SYSTRAY_SYNC_INCOMPLETE);
            stringBuilder.append(Translation.get("systray.tooltip.not_logged_in"));
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.NOT_LOGGED_IN)) {
            image = Icons.getImageById(Icons.SYSTRAY_WARNING);
            stringBuilder.append(Translation.get("systray.tooltip.not_logged_in"));
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.WARNING)) {
            image = Icons.getImageById(Icons.SYSTRAY_WARNING);
            stringBuilder.append(Translation.get("systray.tooltip.warning_notice"));
        } else if (syncStatusEvent.equals((Object)SyncStatusEvent.INFORMATION)) {
            image = Icons.getImageById(Icons.SYSTRAY_SYNC_COMPLETE);
            stringBuilder.append(Translation.get("systray.tooltip.info_notice"));
        } else {
            this.logSevere("Not handling all sync states: " + syncStatusEvent);
            image = Icons.getImageById("question.icon");
        }
        this.atomicSyncing.set(bl);
        this.trayIcon.setImage(image);
        this.trayIcon.setToolTip(stringBuilder.toString());
    }

    private void spinIcon() {
        if (this.atomicSyncing.get()) {
            Object object;
            int n = this.atomicAngle.incrementAndGet();
            if (n >= Icons.SYSTRAY_SYNC_ANIMATION.length) {
                this.atomicAngle.set(0);
                n = 0;
                object = new StringBuilder();
                ((StringBuilder)object).append(Translation.get("systray.tooltip.syncing"));
                double d = this.getController().getUIController().getApplicationModel().getSyncingModel().getOverallSyncPercentage();
                if (d >= 0.0) {
                    ((StringBuilder)object).append(' ');
                    ((StringBuilder)object).append(Format.formatDecimal(d) + "%");
                }
                this.trayIcon.setToolTip(((StringBuilder)object).toString());
            }
            object = Icons.getImageById(Icons.SYSTRAY_SYNC_ANIMATION[n]);
            if (this.trayIcon != null) {
                this.trayIcon.setImage((Image)object);
            }
        }
    }

    public static boolean isHiRes() {
        return OSUtil.isLinux() || OSUtil.isMacOS();
    }

    public static boolean isMacMenuBarDarkMode() {
        if (!OSUtil.isMacOS()) {
            return false;
        }
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"defaults", "read", "-g", "AppleInterfaceStyle"});
            process.waitFor(100L, TimeUnit.MILLISECONDS);
            return process.exitValue() == 0;
        }
        catch (IOException | IllegalThreadStateException | InterruptedException exception) {
            Logger.getLogger(TrayIconManager.class.getName()).warning("Could not determine, whether 'dark mode' is being used. Falling back to default (light) mode." + exception);
            return false;
        }
    }

    private class SpinnerTask
    extends TimerTask {
        private SpinnerTask() {
        }

        @Override
        public void run() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TrayIconManager.this.spinIcon();
                }
            });
        }
    }
}

