/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.computers.ComputersTab;
import de.dal33t.powerfolder.ui.folders.FoldersTab;
import de.dal33t.powerfolder.ui.util.CursorUtils;
import de.dal33t.powerfolder.util.Translation;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainTabbedPane
extends PFUIComponent {
    public static final int FOLDERS_INDEX = 0;
    public static final int COMPUTERS_INDEX = 1;
    private FoldersTab foldersTab;
    private ComputersTab computersTab;
    private JTabbedPane tabbedPane;
    private final boolean showComputersTab;
    private final boolean showDeviceTab;
    private final AtomicBoolean initialized = new AtomicBoolean();

    public MainTabbedPane(Controller controller) {
        super(controller);
        this.showComputersTab = !this.getController().isBackupOnly();
        this.showDeviceTab = PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()) != false && PreferencesEntry.SHOW_DEVICES.getValueBoolean(this.getController()) != false;
    }

    public JComponent getUIComponent() {
        if (!this.initialized.getAndSet(true)) {
            this.initComponents();
            if (this.showDeviceTab) {
                this.tabbedPane.add(Translation.get("main_tabbed_pane.folders.name"), this.foldersTab.getUIComponent());
                if (this.showComputersTab) {
                    this.tabbedPane.add(Translation.get("exp.main_tabbed_pane.computers.name"), this.computersTab.getUIComponent());
                } else {
                    this.computersTab.getUIComponent();
                }
                String string = Translation.get("main_tabbed_pane.folders.key");
                this.tabbedPane.setMnemonicAt(0, Character.toUpperCase(string.charAt(0)));
                this.tabbedPane.setToolTipTextAt(0, Translation.get("main_tabbed_pane.folders.description"));
                if (this.showComputersTab) {
                    string = Translation.get("exp.main_tabbed_pane.computers.key");
                    this.tabbedPane.setMnemonicAt(1, Character.toUpperCase(string.charAt(0)));
                    this.tabbedPane.setToolTipTextAt(1, Translation.get("exp.main_tabbed_pane.computers.description"));
                }
                this.tabbedPane.addChangeListener(new MyChangelistener());
                CursorUtils.setHandCursor(this.tabbedPane);
                CursorUtils.setDefaultCursor(this.foldersTab.getUIComponent());
                CursorUtils.setDefaultCursor(this.computersTab.getUIComponent());
                this.setActiveTab(0);
            }
            this.foldersTab.populate();
        }
        if (this.showDeviceTab) {
            return this.tabbedPane;
        }
        return this.foldersTab.getUIComponent();
    }

    public int getSelectedTabIndex() {
        if (this.showDeviceTab) {
            return this.tabbedPane.getSelectedIndex();
        }
        throw new IllegalStateException("Expert mode == " + this.showDeviceTab);
    }

    private void initComponents() {
        this.foldersTab = new FoldersTab(this.getController());
        if (this.showDeviceTab) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setOpaque(false);
            this.computersTab = new ComputersTab(this.getController());
        }
    }

    public FoldersTab getFoldersTab() {
        return this.foldersTab;
    }

    public void addTabbedPaneChangeListener(ChangeListener changeListener) {
        if (this.showDeviceTab) {
            this.tabbedPane.addChangeListener(changeListener);
        }
    }

    public void removeTabbedPaneChangeListener(ChangeListener changeListener) {
        if (this.showDeviceTab) {
            this.tabbedPane.removeChangeListener(changeListener);
        }
    }

    public void setActiveTab(int n) {
        if (this.showDeviceTab) {
            this.tabbedPane.setSelectedIndex(n);
        }
    }

    private class MyChangelistener
    implements ChangeListener {
        private AtomicBoolean done = new AtomicBoolean();

        private MyChangelistener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!this.done.getAndSet(true)) {
                MainTabbedPane.this.foldersTab.populate();
                MainTabbedPane.this.computersTab.populate();
            }
        }
    }
}

