/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.transfer.BandwidthLimiter;
import de.dal33t.powerfolder.transfer.LimitedStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream
implements LimitedStream {
    protected BandwidthLimiter limiter;

    public LimitedInputStream(BandwidthLimiter bandwidthLimiter, InputStream inputStream) {
        super(inputStream);
        this.limiter = bandwidthLimiter;
    }

    @Override
    public int read() throws IOException {
        try {
            this.limiter.requestBandwidth(1L);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.toString());
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        try {
            n3 = (int)this.limiter.requestBandwidth(n2);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.toString());
        }
        int n4 = this.in.read(byArray, n, n3);
        this.limiter.returnAvailable(n3 - n4);
        return n4;
    }

    @Override
    public BandwidthLimiter getBandwidthLimiter() {
        return this.limiter;
    }

    @Override
    public void setBandwidthLimiter(BandwidthLimiter bandwidthLimiter) {
        this.limiter = bandwidthLimiter;
    }
}

