/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderStatistic;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.message.FileChunk;
import de.dal33t.powerfolder.transfer.BrokenDownloadException;
import de.dal33t.powerfolder.transfer.Download;
import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.transfer.Transfer;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.transfer.TransferProblem;
import de.dal33t.powerfolder.ui.notices.WarningNotice;
import de.dal33t.powerfolder.util.Base64;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.DateUtil;
import de.dal33t.powerfolder.util.Debug;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.ProgressListener;
import de.dal33t.powerfolder.util.Range;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.TransferCounter;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.delta.FilePartsRecord;
import de.dal33t.powerfolder.util.delta.FilePartsState;
import de.dal33t.powerfolder.util.delta.MatchCopyWorker;
import de.dal33t.powerfolder.util.delta.MatchResultWorker;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractDownloadManager
extends PFComponent
implements DownloadManager {
    protected FilePartsState filePartsState;
    protected FilePartsRecord remotePartRecord;
    private volatile TransferCounter counter;
    private Transfer.State transferState = new Transfer.State();
    private final FileInfo fileInfo;
    private Controller controller;
    private FileChannel tempFileChannel = null;
    private volatile InternalState state = null;
    private volatile boolean automatic;
    private volatile boolean started;
    private volatile boolean shutdown;
    private Path metaFile;
    private String fileID;
    private Path tempFile;
    private final TransferManager tm;
    private Path metaDataBaseDir;

    public AbstractDownloadManager(Controller controller, FileInfo fileInfo, boolean bl) {
        Reject.noNullElements(controller, fileInfo);
        this.fileInfo = fileInfo;
        this.automatic = bl;
        this.controller = controller;
        this.tm = controller.getTransferManager();
        this.counter = new TransferCounter(0L, this.fileInfo.getSize());
    }

    @Override
    public synchronized void abort() {
        switch (this.state) {
            case ABORTED: {
                this.logFine("Already aborted download of " + this.fileInfo.toDetailString());
                break;
            }
            case BROKEN: 
            case COMPLETED: {
                break;
            }
            default: {
                this.setAborted(false);
            }
        }
    }

    @Override
    public synchronized void abortAndCleanup() {
        switch (this.state) {
            case ABORTED: {
                this.logFine("Already aborted download of " + this.fileInfo.toDetailString());
                break;
            }
            case BROKEN: 
            case COMPLETED: {
                break;
            }
            default: {
                this.setAborted(true);
            }
        }
    }

    @Override
    public synchronized boolean addSource(Download download) {
        this.validateDownload(download);
        Reject.ifFalse(download.isCompleted() || this.canAddSource(download.getPartner()), "Illegal addSource() call!!");
        return this.addSource0(download);
    }

    @Override
    public synchronized void chunkReceived(Download download, FileChunk fileChunk) {
        Reject.noNullElements(download, fileChunk);
        this.validateDownload(download);
        assert (fileChunk.file.isVersionDateAndSizeIdentical(this.getFileInfo()));
        try {
            this.receivedChunk0(download, fileChunk);
        }
        catch (BrokenDownloadException brokenDownloadException) {
            this.setBroken(TransferProblem.BROKEN_DOWNLOAD, brokenDownloadException.toString());
        }
    }

    @Override
    public synchronized void filePartsRecordReceived(Download download, FilePartsRecord filePartsRecord) {
        Reject.noNullElements(download, filePartsRecord);
        this.validateDownload(download);
        try {
            this.receivedFilePartsRecord0(download, filePartsRecord);
        }
        catch (BrokenDownloadException brokenDownloadException) {
            this.setBroken(TransferProblem.BROKEN_DOWNLOAD, brokenDownloadException.toString());
        }
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    @Override
    public TransferCounter getCounter() {
        return this.counter;
    }

    @Override
    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    @Override
    public Transfer.State getState() {
        return this.transferState;
    }

    @Override
    public synchronized Path getTempFile() {
        Path path = this.getFileInfo().getDiskFile(this.getController().getFolderRepository());
        if (path == null) {
            return null;
        }
        if (this.tempFile == null) {
            try {
                this.tempFile = this.getMetaDataBaseDir().resolve("(incomplete) " + this.getFileID());
            }
            catch (IOException iOException) {
                this.logSevere("IOException", iOException);
                return null;
            }
        }
        return this.tempFile;
    }

    public boolean isBroken() {
        return this.state == InternalState.BROKEN;
    }

    @Override
    public boolean isCompleted() {
        return this.state == InternalState.COMPLETED;
    }

    @Override
    public boolean isDone() {
        return this.state.isDone();
    }

    @Override
    public boolean isRequestedAutomatic() {
        return this.automatic;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public synchronized void readyForRequests(Download download) {
        this.validateDownload(download);
        try {
            this.readyForRequests0(download);
        }
        catch (BrokenDownloadException brokenDownloadException) {
            this.setBroken(TransferProblem.BROKEN_DOWNLOAD, brokenDownloadException.toString());
        }
        catch (AssertionError assertionError) {
            this.logSevere("AssertionError", (Throwable)((Object)assertionError));
            throw assertionError;
        }
    }

    @Override
    public synchronized void removeSource(Download download) {
        this.validateDownload(download);
        try {
            this.removeSource0(download);
        }
        catch (BrokenDownloadException brokenDownloadException) {
            this.setBroken(TransferProblem.BROKEN_DOWNLOAD, brokenDownloadException.toString());
        }
    }

    public String toString() {
        String string = this.tempFile == null ? "n/a" : this.tempFile.toString();
        return "[" + this.getClass().getSimpleName() + "; state= " + this.state + " file=" + this.getFileInfo() + "; tempFileRAF: " + this.tempFileChannel + "; tempFile: " + string + "; broken: " + this.isBroken() + "; completed: " + this.isCompleted() + "; aborted: " + this.isAborted() + "; partsState: " + this.filePartsState;
    }

    protected abstract void addSourceImpl(Download var1);

    protected boolean checkCompleted() {
        this.setTransferState(Transfer.TransferState.VERIFYING);
        try {
            FilePartsRecord filePartsRecord = this.remotePartRecord;
            byte[] byArray = null;
            if (filePartsRecord != null) {
                byArray = PathUtils.digest(this.getTempFile(), MessageDigest.getInstance("MD5"), new ProgressListener(){

                    @Override
                    public void progressReached(double d) {
                        AbstractDownloadManager.this.setTransferState(d / 100.0);
                    }
                });
            }
            if (byArray == null || Arrays.equals(filePartsRecord.getFileDigest(), byArray)) {
                return true;
            }
            this.logFine("MD5 Checksum check FAILED on " + this.fileInfo.toDetailString() + ". found: " + Base64.encodeBytes(byArray) + " expected: " + Base64.encodeBytes(filePartsRecord.getFileDigest()));
            this.counter = new TransferCounter(0L, this.fileInfo.getSize());
            this.filePartsState = null;
            this.remotePartRecord = null;
            return false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.logSevere("NoSuchAlgorithmException", noSuchAlgorithmException);
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            this.logWarning("IOException: " + iOException);
            this.setBroken(TransferProblem.GENERAL_EXCEPTION, iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            this.setBroken(TransferProblem.GENERAL_EXCEPTION, interruptedException.getMessage());
        }
        catch (Exception exception) {
            this.logSevere("Exception", exception);
            this.setBroken(TransferProblem.GENERAL_EXCEPTION, exception.getMessage());
        }
        return false;
    }

    protected Path getFile() {
        return this.fileInfo.getDiskFile(this.getController().getFolderRepository());
    }

    @Override
    public synchronized void init(boolean bl) throws IOException {
        assert (this.fileInfo != null);
        if (bl) {
            this.setTransferState(Transfer.TransferState.DONE, 1.0);
            this.state = InternalState.COMPLETED;
        } else {
            this.setTransferState(Transfer.TransferState.NONE);
            this.state = InternalState.WAITING_FOR_SOURCE;
        }
        if (this.isCompleted()) {
            return;
        }
        Path path = this.getTempFile();
        if (path == null) {
            throw new IOException("Couldn't create a temporary file for " + this.fileInfo);
        }
        this.loadMetaData();
        if (this.isFiner()) {
            this.logFiner("Init tempfile at " + this.getTempFile());
        }
        try {
            this.tempFileChannel = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            this.tempFileChannel = FileChannel.open(path, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
        }
    }

    protected boolean isNeedingFilePartsRecord() {
        return !this.isCompleted() && this.remotePartRecord == null && this.fileInfo.getSize() >= 8192L && this.fileInfo.diskFileExists(this.getController());
    }

    protected void matchAndCopyData() throws BrokenDownloadException, InterruptedException {
        try {
            Path path = this.getFile();
            this.setTransferState(Transfer.TransferState.MATCHING);
            ProgressListener progressListener = new ProgressListener(){

                @Override
                public void progressReached(double d) {
                    AbstractDownloadManager.this.setTransferState(d);
                }
            };
            MatchResultWorker matchResultWorker = new MatchResultWorker(this.remotePartRecord, path, progressListener);
            List list = null;
            list = (List)matchResultWorker.call();
            if (this.isFine()) {
                this.logFine("Matches: " + list.size() + " which are " + Format.formatBytes(this.remotePartRecord.getPartLength() * list.size()) + " bytes (bit less maybe) on " + this.fileInfo.toDetailString());
            }
            this.setTransferState(Transfer.TransferState.COPYING);
            MatchCopyWorker matchCopyWorker = new MatchCopyWorker(path, this.getTempFile(), this.remotePartRecord, list, progressListener);
            FilePartsState filePartsState = (FilePartsState)matchCopyWorker.call();
            if (filePartsState.getFileLength() != this.fileInfo.getSize()) {
                throw new BrokenDownloadException();
            }
            this.setFilePartsState(filePartsState);
            this.counter = new TransferCounter(this.filePartsState.countPartStates(this.filePartsState.getRange(), FilePartsState.PartState.AVAILABLE), this.fileInfo.getSize());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("SHA Digest not found. Fatal error", noSuchAlgorithmException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BrokenDownloadException(TransferProblem.FILE_NOT_FOUND_EXCEPTION, fileNotFoundException);
        }
        catch (IOException iOException) {
            this.logWarning(this + ": testDeltaFileChangedMultiple BrokenDownloadException: " + iOException, iOException);
            throw new BrokenDownloadException(TransferProblem.IO_EXCEPTION, iOException);
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Exception exception) {
            throw new BrokenDownloadException(TransferProblem.GENERAL_EXCEPTION, exception);
        }
    }

    protected abstract void removeSourceImpl(Download var1);

    protected abstract void requestFilePartsRecord(Download var1);

    protected abstract void sendPartRequests() throws BrokenDownloadException;

    protected synchronized void setAutomatic(boolean bl) {
        this.automatic = bl;
    }

    @Override
    public synchronized void setBroken(TransferProblem transferProblem, String string) {
        Object object;
        if (this.isBroken()) {
            return;
        }
        if (this.isFine()) {
            this.logFine("Download broken: " + this.fileInfo.toDetailString() + ". Problem: " + transferProblem + ": " + string);
        }
        this.setState(InternalState.BROKEN);
        this.shutdown();
        if (transferProblem.equals((Object)TransferProblem.MD5_ERROR)) {
            try {
                this.deleteTempFile();
            }
            catch (IOException iOException) {
                this.logSevere("Unable to remove tempfile on MD5_ERROR: " + this.getTempFile().toString() + ". " + iOException, iOException);
            }
            if (this.isRequestedAutomatic() && (object = this.getFileInfo().getFolder(this.getController().getFolderRepository())) != null) {
                this.logInfo("Auto-recover from MD5_ERROR: Re-download of " + this.getFileInfo() + " started. Message: " + string);
                if (((Folder)object).erase(this.getFileInfo())) {
                    this.tm.doWork(new Runnable(){

                        @Override
                        public void run() {
                            AbstractDownloadManager.this.tm.downloadNewestVersion(AbstractDownloadManager.this.getFileInfo(), true);
                        }
                    });
                }
            }
        } else {
            try {
                if (this.getTempFile() != null && Files.exists(this.getTempFile(), new LinkOption[0]) && Files.size(this.getTempFile()) == 0L) {
                    if (this.isFiner()) {
                        this.logFiner("Deleting tempfile with size 0.");
                    }
                    Files.delete(this.getTempFile());
                }
            }
            catch (IOException iOException) {
                this.logWarning("Failed to delete temp file: " + this.getTempFile().toAbsolutePath().toString() + ". " + iOException);
            }
        }
        object = this.getSources().toArray(new Download[0]);
        for (Download download : object) {
            download.setBroken(transferProblem, string);
        }
        this.tm.downloadManagerBroken(this, transferProblem, string);
    }

    protected synchronized void setCompleted() {
        try {
            if (this.isDone()) {
                return;
            }
            if (this.isInfo()) {
                if (this.fileInfo.getFolderInfo().isMetaFolder()) {
                    this.logFine("Download completed: " + this.fileInfo.toDetailString());
                } else {
                    this.logInfo("Download completed: " + this.fileInfo.toDetailString());
                }
            }
            this.setTransferState(Transfer.TransferState.DONE, 1.0);
            this.setState(InternalState.COMPLETED);
            this.shutdown();
            this.deleteMetaData();
            this.tm.setCompleted(this);
        }
        catch (RuntimeException runtimeException) {
            this.logWarning("Exception while completing download of " + this.fileInfo.toDetailString(), runtimeException);
        }
    }

    protected synchronized void setFilePartsState(FilePartsState filePartsState) {
        assert (this.filePartsState == null);
        if (this.filePartsState != null) {
            this.logWarning("FilePartsState should've been null, but was " + this.filePartsState + " on " + this.fileInfo.toDetailString());
            this.logInfo(Debug.getCurrentStackTrace());
        }
        this.filePartsState = filePartsState;
    }

    protected void setStarted() {
        this.started = true;
    }

    protected void setTransferState(double d) {
        this.transferState.setProgress(d);
        for (Download download : this.getSources()) {
            download.state.setProgress(d);
        }
    }

    protected void setTransferState(Transfer.TransferState transferState) {
        if (this.transferState.getState() == transferState) {
            return;
        }
        this.transferState.setState(transferState);
        this.transferState.setProgress(0.0);
        for (Download download : this.getSources()) {
            download.state.setState(transferState);
            download.state.setProgress(0.0);
        }
    }

    protected void setTransferState(Transfer.TransferState transferState, double d) {
        this.transferState.setState(transferState);
        this.transferState.setProgress(d);
        for (Download download : this.getSources()) {
            download.state.setState(transferState);
            download.state.setProgress(d);
        }
    }

    protected synchronized void shutdown() {
        assert (this.isDone());
        if (this.shutdown) {
            return;
        }
        assert (this.tempFileChannel != null);
        this.shutdown = true;
        if (this.isFiner()) {
            this.logFine("Shutting down " + this.fileInfo.toDetailString());
        }
        try {
            if (this.isFiner()) {
                this.logFiner("Closing temp file: " + this.getTempFile() + " of " + this.getFile());
            }
            this.tempFileChannel.close();
            this.tempFileChannel = null;
        }
        catch (IOException iOException) {
            this.logFine("IOException while closing temp file " + this.tempFileChannel + ": " + iOException);
        }
        try {
            if (this.isBroken()) {
                this.saveMetaData();
            } else {
                this.deleteMetaData();
            }
        }
        catch (IOException iOException) {
            this.logWarning("IOException while savining meta-data of partial/broken download: " + iOException);
        }
        this.remotePartRecord = null;
        this.updateTempFile();
        assert (this.tempFileChannel == null);
        assert (!this.isCompleted() && !this.isAborted() || !this.hasMetaFile());
    }

    protected synchronized void startActiveDownload() throws BrokenDownloadException {
        assert (!this.getSources().isEmpty());
        assert (!this.isDone());
        this.setStarted();
        this.setState(InternalState.ACTIVE_DOWNLOAD);
        if (this.isFiner()) {
            this.logFiner("Requesting parts");
        }
        this.sendPartRequests();
    }

    protected synchronized void storeFileChunk(Download download, FileChunk fileChunk) {
        FolderStatistic folderStatistic;
        assert (download != null);
        assert (fileChunk != null);
        assert (this.getSources().contains(download)) : "Invalid source!";
        this.setStarted();
        try {
            this.tempFileChannel.position(fileChunk.offset);
            this.tempFileChannel.write(ByteBuffer.wrap(fileChunk.data));
        }
        catch (IOException iOException) {
            if (PathUtils.isQuotaLimitHit(iOException)) {
                this.logWarning("Pausing sync. Filesystem quota hit at " + this.tempFile);
                this.getController().setPaused(true);
                if (this.getController().isUIEnabled()) {
                    WarningNotice warningNotice = new WarningNotice(Translation.get("disc_space_warning.title"), Translation.get("disc_space_warning.summary"), Translation.get("disc_space_warning.summary"));
                    this.getController().getUIController().getApplicationModel().getNoticesModel().handleNotice(warningNotice);
                }
            } else {
                this.logWarning("IOException while writing to " + this.tempFile, iOException);
            }
            this.setBroken(TransferProblem.IO_EXCEPTION, "Couldn't write to tempfile");
            return;
        }
        this.getCounter().chunkTransferred(fileChunk);
        Range range = Range.getRangeByLength(fileChunk.offset, fileChunk.data.length);
        this.filePartsState.setPartState(range, FilePartsState.PartState.AVAILABLE);
        long l = this.filePartsState.countPartStates(this.filePartsState.getRange(), FilePartsState.PartState.AVAILABLE);
        this.setTransferState(Transfer.TransferState.DOWNLOADING, this.fileInfo.getSize() > 0L ? (double)l / (double)this.fileInfo.getSize() : 1.0);
        Folder folder = this.fileInfo.getFolder(this.getController().getFolderRepository());
        FolderStatistic folderStatistic2 = folderStatistic = folder != null ? folder.getStatistic() : null;
        if (folderStatistic != null) {
            folderStatistic.getDownloadCounter().chunkTransferred(fileChunk);
        }
    }

    private boolean addSource0(Download download) {
        assert (download.isCompleted() || this.canAddSource(download.getPartner())) : "Illegal addSource() call!!";
        switch (this.state) {
            case BROKEN: {
                download.setBroken(TransferProblem.BROKEN_DOWNLOAD, "Manager already broken!");
                return false;
            }
            case MATCHING_AND_COPYING: 
            case CHECKING_FILE_VALIDITY: 
            case ACTIVE_DOWNLOAD: 
            case WAITING_FOR_UPLOAD_READY: 
            case WAITING_FOR_FILEPARTSRECORD: {
                this.addSourceImpl(download);
                download.request(0L);
                return true;
            }
            case WAITING_FOR_SOURCE: {
                if (download.isCompleted()) {
                    this.setState(InternalState.COMPLETED);
                }
                this.addSourceImpl(download);
                if (this.isDone()) {
                    return false;
                }
                if (this.getFileInfo().getSize() == 0L) {
                    this.setCompleted();
                    return false;
                }
                long l = 0L;
                if (this.filePartsState != null) {
                    assert (!this.filePartsState.isCompleted());
                    Range range = this.filePartsState.findFirstPart(FilePartsState.PartState.NEEDED);
                    if (range != null) {
                        l = range.getStart();
                    } else assert (this.filePartsState.isCompleted() || this.filePartsState.findFirstPart(FilePartsState.PartState.PENDING) != null);
                }
                this.setState(InternalState.WAITING_FOR_UPLOAD_READY);
                download.request(l);
                return true;
            }
            case COMPLETED: {
                this.addSourceImpl(download);
                if (!download.isCompleted() && !download.isBroken()) {
                    download.setCompleted();
                }
                return false;
            }
        }
        this.illegalState("addSource");
        return false;
    }

    private void validateDownload(Download download) {
        Reject.ifNull(download, "Download is null!");
        if (!download.getFile().isVersionDateAndSizeIdentical(this.getFileInfo())) {
            throw new IllegalArgumentException("Download FileInfo differs: " + download.getFile().toDetailString() + " vs mine: " + this.getFileInfo().toDetailString());
        }
    }

    private synchronized void checkFileValidity() {
        assert (this.state == InternalState.ACTIVE_DOWNLOAD || this.state == InternalState.WAITING_FOR_UPLOAD_READY && this.filePartsState.getFileLength() == 0L || this.state == InternalState.MATCHING_AND_COPYING) : "Invalid state: " + this.state;
        this.setState(InternalState.CHECKING_FILE_VALIDITY);
        this.tm.doWork(() -> {
            if (this.checkCompleted()) {
                this.setCompleted();
            } else {
                this.setBroken(TransferProblem.MD5_ERROR, "File hash mismatch");
            }
        });
    }

    private void deleteMetaData() {
        block3: {
            if (this.getMetaFile() != null) {
                try {
                    Files.deleteIfExists(this.getMetaFile());
                }
                catch (IOException iOException) {
                    if (!this.isSevere() || !Files.exists(this.getMetaFile(), new LinkOption[0])) break block3;
                    this.logSevere("Couldn't delete meta data file!");
                }
            }
        }
    }

    private String getFileID() throws Error {
        if (this.fileID == null) {
            this.fileID = new String(Util.encodeHex(Util.md5(this.getFileInfo().getRelativeName().getBytes(Convert.UTF8))));
        }
        return this.fileID;
    }

    private Path getMetaDataBaseDir() throws IOException {
        if (this.metaDataBaseDir != null) {
            return this.metaDataBaseDir;
        }
        this.metaDataBaseDir = this.getFileInfo().getFolder(this.getController().getFolderRepository()).getSystemSubDir().resolve("transfers").toAbsolutePath();
        if (Files.notExists(this.metaDataBaseDir, new LinkOption[0])) {
            try {
                Files.createDirectories(this.metaDataBaseDir, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                throw new IOException("Couldn't create base directory for transfer meta data!");
            }
        }
        return this.metaDataBaseDir;
    }

    private boolean hasMetaFile() {
        return this.getMetaFile() != null && Files.exists(this.getMetaFile(), new LinkOption[0]);
    }

    private Path getMetaFile() {
        if (this.metaFile != null) {
            return this.metaFile;
        }
        Path path = this.getFileInfo().getDiskFile(this.getController().getFolderRepository());
        if (path == null) {
            return null;
        }
        try {
            this.metaFile = this.getMetaDataBaseDir().resolve("(downloadmeta) " + this.getFileID()).toAbsolutePath();
            return this.metaFile;
        }
        catch (IOException iOException) {
            this.logSevere("IOException", iOException);
            return null;
        }
    }

    private void illegalState(String string) {
        throw new IllegalStateException(string + " not allowed in state " + this.state);
    }

    private boolean isAborted() {
        return this.state == InternalState.ABORTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTempFile() throws IOException {
        boolean bl;
        boolean bl2 = bl = this.getTempFile() != null && Files.exists(this.getTempFile(), new LinkOption[0]);
        if (bl && this.isFine()) {
            this.logFine("killTempFile: " + this.getTempFile() + ", size: " + Files.size(this.getTempFile()));
        }
        try {
            Files.deleteIfExists(this.getTempFile());
        }
        catch (IOException iOException) {
            if (this.isWarning()) {
                this.logWarning("Couldn't delete old temporary file, some other process could be using it! Trying to set it's length to 0. for file: " + this.getFileInfo().toDetailString());
            }
            try (FileChannel fileChannel = FileChannel.open(this.getTempFile(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                fileChannel.position(0L);
            }
        }
    }

    private void loadMetaData() throws IOException {
        try {
            if (this.getTempFile() == null || Files.notExists(this.getTempFile(), new LinkOption[0]) || !DateUtil.equalsFileDateCrossPlattform(this.fileInfo.getModifiedDate().getTime(), Files.getLastModifiedTime(this.getTempFile(), new LinkOption[0]).toMillis())) {
                this.deleteMetaData();
                this.deleteTempFile();
                return;
            }
        }
        catch (IOException iOException) {
            this.deleteTempFile();
            this.deleteMetaData();
            return;
        }
        Path path = this.getMetaFile();
        if (path == null || Files.notExists(path, new LinkOption[0])) {
            this.deleteTempFile();
            return;
        }
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));){
            FileInfo fileInfo = (FileInfo)objectInputStream.readObject();
            if (fileInfo.isVersionDateAndSizeIdentical(this.fileInfo)) {
                List list = (List)objectInputStream.readObject();
                for (Object e : list) {
                    if (e.getClass() == FilePartsState.class) {
                        this.setFilePartsState((FilePartsState)e);
                        continue;
                    }
                    if (e.getClass() != FilePartsRecord.class) continue;
                    this.remotePartRecord = (FilePartsRecord)e;
                }
            } else {
                objectInputStream.close();
                this.deleteTempFile();
                this.deleteMetaData();
            }
        }
        catch (Exception exception) {
            this.remotePartRecord = null;
            this.filePartsState = null;
            this.deleteMetaData();
        }
        if (this.filePartsState != null && this.isInfo()) {
            this.logInfo("Resuming download " + this.getFileInfo().toDetailString() + " - already got " + this.filePartsState.countPartStates(this.filePartsState.getRange(), FilePartsState.PartState.AVAILABLE) + " of " + this.getFileInfo().getSize());
        }
    }

    private void protocolStateError(Download download, String string) throws BrokenDownloadException {
        String string2 = "PROTOCOL ERROR caused by " + download + ": " + string + " not allowed in state " + this.state;
        string2 = string2 + " use DS: " + Util.useDeltaSync(this.getController(), download) + " use Swarm: " + Util.useSwarming(this.getController(), download.getPartner());
        this.logWarning(string2);
        throw new BrokenDownloadException(string2);
    }

    private void readyForRequests0(Download download) throws BrokenDownloadException {
        switch (this.state) {
            case MATCHING_AND_COPYING: 
            case CHECKING_FILE_VALIDITY: {
                break;
            }
            case ACTIVE_DOWNLOAD: {
                this.sendPartRequests();
                break;
            }
            case WAITING_FOR_FILEPARTSRECORD: {
                this.requestFilePartsRecord(download);
                break;
            }
            case WAITING_FOR_UPLOAD_READY: {
                if (this.isNeedingFilePartsRecord() && Util.useDeltaSync(this.getController(), download)) {
                    this.setState(InternalState.WAITING_FOR_FILEPARTSRECORD);
                    this.requestFilePartsRecord(download);
                    break;
                }
                if (this.filePartsState == null) {
                    this.setFilePartsState(new FilePartsState(this.fileInfo.getSize()));
                }
                if (this.filePartsState.isCompleted()) {
                    if (this.isFine()) {
                        this.logFine("Not requesting anything, seems to be a zero file: " + this.fileInfo);
                    }
                    this.checkFileValidity();
                    break;
                }
                if (this.isFiner()) {
                    this.logFiner("Not requesting record for this download.");
                }
                this.startActiveDownload();
                break;
            }
            case ABORTED: 
            case BROKEN: 
            case COMPLETED: {
                download.abort();
                break;
            }
            default: {
                this.protocolStateError(download, "readyForRequests");
            }
        }
    }

    private void receivedChunk0(Download download, FileChunk fileChunk) throws BrokenDownloadException {
        switch (this.state) {
            case ABORTED: 
            case BROKEN: {
                if (this.isFine()) {
                    this.logFine("Aborted download of " + this.fileInfo + " received chunk from " + download);
                }
                download.abort();
                break;
            }
            case ACTIVE_DOWNLOAD: {
                this.storeFileChunk(download, fileChunk);
                if (this.filePartsState.isCompleted()) {
                    this.checkFileValidity();
                    break;
                }
                this.sendPartRequests();
                break;
            }
            case PASSIVE_DOWNLOAD: {
                this.storeFileChunk(download, fileChunk);
                if (!this.filePartsState.isCompleted()) break;
                this.setCompleted();
                break;
            }
            case WAITING_FOR_UPLOAD_READY: {
                this.setState(InternalState.PASSIVE_DOWNLOAD);
                this.setFilePartsState(new FilePartsState(this.fileInfo.getSize()));
                this.filePartsState.setPartState(this.filePartsState.getRange(), FilePartsState.PartState.NEEDED);
                this.receivedChunk0(download, fileChunk);
                break;
            }
            default: {
                this.protocolStateError(download, "receivedChunk");
            }
        }
    }

    private void receivedFilePartsRecord0(Download download, FilePartsRecord filePartsRecord) throws BrokenDownloadException {
        switch (this.state) {
            case WAITING_FOR_FILEPARTSRECORD: {
                if (this.isFine()) {
                    this.logFine("Matching and copying..." + this.fileInfo.toDetailString());
                }
                this.setState(InternalState.MATCHING_AND_COPYING);
                this.remotePartRecord = filePartsRecord;
                this.tm.doWork(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block12: {
                            try {
                                AbstractDownloadManager.this.matchAndCopyData();
                                if (AbstractDownloadManager.this.isDone()) {
                                    return;
                                }
                                if (AbstractDownloadManager.this.filePartsState.isCompleted()) {
                                    AbstractDownloadManager.this.checkFileValidity();
                                    break block12;
                                }
                                AbstractDownloadManager abstractDownloadManager = AbstractDownloadManager.this;
                                synchronized (abstractDownloadManager) {
                                    if (AbstractDownloadManager.this.getSources().isEmpty()) {
                                        throw new BrokenDownloadException("Out of sources");
                                    }
                                    if (!AbstractDownloadManager.this.isDone()) {
                                        try {
                                            AbstractDownloadManager.this.startActiveDownload();
                                        }
                                        catch (BrokenDownloadException brokenDownloadException) {
                                            AbstractDownloadManager.this.setBroken(TransferProblem.IO_EXCEPTION, brokenDownloadException.toString());
                                        }
                                    }
                                }
                            }
                            catch (BrokenDownloadException brokenDownloadException) {
                                AbstractDownloadManager.this.setBroken(TransferProblem.IO_EXCEPTION, brokenDownloadException.toString());
                            }
                            catch (InterruptedException interruptedException) {
                                AbstractDownloadManager.this.logFiner("InterruptedException", interruptedException);
                            }
                        }
                    }
                });
                break;
            }
            default: {
                this.protocolStateError(download, "receivedFilePartsRecord");
            }
        }
    }

    private void removeSource0(Download download) throws BrokenDownloadException {
        switch (this.state) {
            case WAITING_FOR_FILEPARTSRECORD: {
                this.removeSourceImpl(download);
                this.requestFilePartsRecord(null);
                break;
            }
            case WAITING_FOR_UPLOAD_READY: {
                this.removeSourceImpl(download);
                if (this.hasSources()) break;
                this.setState(InternalState.WAITING_FOR_SOURCE);
                break;
            }
            case ACTIVE_DOWNLOAD: {
                this.removeSourceImpl(download);
                if (!this.hasSources()) break;
                this.sendPartRequests();
                break;
            }
            case PASSIVE_DOWNLOAD: {
                this.removeSourceImpl(download);
                if (this.isDone()) break;
                this.setBroken(TransferProblem.BROKEN_DOWNLOAD, "Source lost.");
                break;
            }
            case ABORTED: 
            case BROKEN: 
            case COMPLETED: 
            case MATCHING_AND_COPYING: 
            case CHECKING_FILE_VALIDITY: {
                this.removeSourceImpl(download);
                break;
            }
            default: {
                this.illegalState("removeSource");
            }
        }
    }

    private void saveMetaData() throws IOException {
        assert (this.state != InternalState.COMPLETED);
        Path path = this.getMetaFile();
        if (path == null && !this.isCompleted()) {
            this.deleteTempFile();
            return;
        }
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            objectOutputStream.writeObject(this.fileInfo);
            LinkedList<Serializable> linkedList = new LinkedList<Serializable>();
            if (this.filePartsState != null) {
                this.filePartsState.purgePending();
                linkedList.add(this.filePartsState);
            }
            if (this.remotePartRecord != null) {
                linkedList.add(this.remotePartRecord);
            }
            objectOutputStream.writeObject(linkedList);
        }
    }

    private void setAborted(boolean bl) {
        Download[] downloadArray;
        assert (!this.isAborted());
        assert (Thread.holdsLock(this));
        if (this.isDone()) {
            return;
        }
        if (this.isFine()) {
            this.logFine("Download aborted: " + this.fileInfo);
        }
        this.setState(InternalState.ABORTED);
        this.shutdown();
        if (bl) {
            try {
                this.deleteTempFile();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logSevere("FileNotFoundException", fileNotFoundException);
            }
            catch (IOException iOException) {
                this.logSevere("IOException", iOException);
            }
            this.deleteMetaData();
        }
        for (Download download : downloadArray = this.getSources().toArray(new Download[0])) {
            download.abort();
        }
        this.tm.downloadManagerAborted(this);
    }

    private void setState(InternalState internalState) {
        assert (Thread.holdsLock(this));
        if (internalState == InternalState.WAITING_FOR_UPLOAD_READY) assert (this.filePartsState == null || !this.filePartsState.isCompleted());
        if (this.isFiner()) {
            this.logFiner("State change to " + internalState + ": " + this.getFileInfo().toDetailString());
        }
        this.state = internalState;
    }

    private void updateTempFile() {
        Path path = this.getTempFile();
        if (path != null) {
            try {
                Files.setLastModifiedTime(path, FileTime.fromMillis(this.getFileInfo().getModifiedDate().getTime()));
                return;
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException iOException) {
                this.logWarning("Unable to update modification date! " + this.getTempFile() + ". " + iOException);
            }
        }
    }

    private static enum InternalState {
        WAITING_FOR_SOURCE,
        WAITING_FOR_UPLOAD_READY,
        WAITING_FOR_FILEPARTSRECORD,
        COMPLETED{

            @Override
            public boolean isDone() {
                return true;
            }
        }
        ,
        BROKEN{

            @Override
            public boolean isDone() {
                return true;
            }
        }
        ,
        ABORTED{

            @Override
            public boolean isDone() {
                return true;
            }
        }
        ,
        ACTIVE_DOWNLOAD,
        MATCHING_AND_COPYING,
        CHECKING_FILE_VALIDITY,
        PASSIVE_DOWNLOAD;


        public boolean isDone() {
            return false;
        }
    }
}

