/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.test;

import java.io.FileInputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;

class TestKey {
    TestKey() {
    }

    public static void main(String[] stringArray) {
        try {
            byte by;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA");
            keyPairGenerator.initialize(1024, SecureRandom.getInstance("SHA1PRNG"));
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Signature signature = Signature.getInstance("SHA/DSA");
            PrivateKey privateKey = keyPair.getPrivate();
            signature.initSign(privateKey);
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            while (fileInputStream.available() != 0) {
                by = (byte)fileInputStream.read();
                signature.update(by);
            }
            fileInputStream.close();
            byte[] byArray = signature.sign();
            PublicKey publicKey = keyPair.getPublic();
            signature.initVerify(publicKey);
            fileInputStream = new FileInputStream(stringArray[0]);
            while (fileInputStream.available() != 0) {
                by = (byte)fileInputStream.read();
                signature.update(by);
            }
            fileInputStream.close();
            boolean bl = signature.verify(byArray);
            System.out.println("signature verifies: " + bl);
        }
        catch (Exception exception) {
            System.err.println("Caught exception " + exception.toString());
        }
    }
}

