/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.task;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.task.PersistentTaskManager;
import de.dal33t.powerfolder.util.Reject;
import java.io.Serializable;
import java.util.Calendar;
import java.util.logging.Logger;

public abstract class PersistentTask
implements Serializable {
    protected static final int DEFAULT_DAYS_TO_EXIPRE = 30;
    private static final long serialVersionUID = -2476895105703987123L;
    private transient PersistentTaskManager manager;
    private Calendar expires;

    public PersistentTask(int n) {
        if (n > 0) {
            this.expires = Calendar.getInstance();
            this.expires.add(5, n);
        }
    }

    public boolean scheduleTask(Controller controller) {
        Reject.ifNull(controller, "Controller");
        if (!controller.getTaskManager().isStarted()) {
            Logger.getLogger(PersistentTask.class.getName()).warning("Unable to schedule task. Task manager not started. " + this);
            return false;
        }
        controller.getTaskManager().scheduleTask(this);
        return true;
    }

    protected boolean isExpired() {
        return this.expires != null && Calendar.getInstance().compareTo(this.expires) >= 0;
    }

    protected Calendar getExpires() {
        return this.expires;
    }

    public final void init(PersistentTaskManager persistentTaskManager) {
        this.manager = persistentTaskManager;
        this.initialize();
    }

    public abstract void initialize();

    public void shutdown() {
    }

    protected final Controller getController() {
        return this.manager.getController();
    }

    public void remove() {
        this.manager.removeTask(this);
    }
}

