/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.security.FolderPermission;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;

public class MemberAccountPermission {
    private Folder folder;
    private Member member;
    private AccountInfo accountInfo;
    private FolderPermission permission;

    public MemberAccountPermission(Folder folder, Member member, AccountInfo accountInfo, FolderPermission folderPermission) {
        this.folder = folder;
        this.member = member;
        this.accountInfo = accountInfo;
        this.permission = folderPermission;
    }

    public static Collection<MemberAccountPermission> collect(Folder folder, Map<AccountInfo, FolderPermission> map) {
        Object object;
        TreeSet<MemberAccountPermission> treeSet = new TreeSet<MemberAccountPermission>(ComparatorType.BY_COMPUTER_NAME_DISPLAY_NAME);
        treeSet.clear();
        for (Member object2 : folder.getMembersAsCollection()) {
            object = object2.getAccountInfo();
            FolderPermission folderPermission = map.get(object);
            MemberAccountPermission memberAccountPermission = new MemberAccountPermission(folder, object2, (AccountInfo)object, folderPermission);
            treeSet.add(memberAccountPermission);
        }
        for (Member member : folder.getMembersAsCollection()) {
            object = member.getAccountInfo();
            if (object == null) continue;
            map.remove(object);
        }
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                object = new MemberAccountPermission(folder, null, (AccountInfo)entry.getKey(), (FolderPermission)entry.getValue());
                treeSet.add((MemberAccountPermission)object);
            }
        }
        return treeSet;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public Member getMember() {
        return this.member;
    }

    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    public FolderPermission getPermission() {
        return this.permission;
    }

    public static enum ComparatorType implements Comparator<MemberAccountPermission>
    {
        BY_TYPE{

            @Override
            public int compare(MemberAccountPermission memberAccountPermission, MemberAccountPermission memberAccountPermission2) {
                boolean bl;
                Member member = memberAccountPermission.getMember();
                Member member2 = memberAccountPermission2.getMember();
                if (member == null) {
                    return member2 == null ? 0 : -1;
                }
                if (member2 == null) {
                    return 1;
                }
                boolean bl2 = member.isFriend();
                boolean bl3 = member2.isFriend();
                boolean bl4 = member.isCompletelyConnected() || member.isMySelf();
                boolean bl5 = bl = member2.isCompletelyConnected() || member2.isMySelf();
                if (bl2 != bl3) {
                    return bl2 ? 1 : -1;
                }
                if (bl4 != bl) {
                    return bl4 ? 1 : -1;
                }
                return 0;
            }
        }
        ,
        BY_COMPUTER_NAME{

            @Override
            public int compare(MemberAccountPermission memberAccountPermission, MemberAccountPermission memberAccountPermission2) {
                Member member = memberAccountPermission.getMember();
                Member member2 = memberAccountPermission2.getMember();
                if (member == null) {
                    return member2 == null ? 0 : 1;
                }
                if (member2 == null) {
                    return -1;
                }
                return member.getNick().compareTo(member2.getNick());
            }
        }
        ,
        BY_COMPUTER_NAME_DISPLAY_NAME{

            @Override
            public int compare(MemberAccountPermission memberAccountPermission, MemberAccountPermission memberAccountPermission2) {
                int n = BY_COMPUTER_NAME.compare(memberAccountPermission, memberAccountPermission2);
                if (n == 0) {
                    n = BY_DISPLAY_NAME.compare(memberAccountPermission, memberAccountPermission2);
                }
                return n;
            }
        }
        ,
        BY_SYNC_STATUS{

            @Override
            public int compare(MemberAccountPermission memberAccountPermission, MemberAccountPermission memberAccountPermission2) {
                Double d = memberAccountPermission.getFolder().getStatistic().getSyncPercentage(memberAccountPermission.getMember());
                Double d2 = memberAccountPermission2.getFolder().getStatistic().getSyncPercentage(memberAccountPermission2.getMember());
                if (d == null) {
                    return d2 == null ? 0 : -1;
                }
                if (d2 == null) {
                    return 1;
                }
                return d.compareTo(d2);
            }
        }
        ,
        BY_LOCAL_SIZE{

            @Override
            public int compare(MemberAccountPermission memberAccountPermission, MemberAccountPermission memberAccountPermission2) {
                Long l = memberAccountPermission.getFolder().getStatistic().getSizeInSync(memberAccountPermission.getMember());
                Long l2 = memberAccountPermission2.getFolder().getStatistic().getSizeInSync(memberAccountPermission2.getMember());
                if (l == null) {
                    return l2 == null ? 0 : 1;
                }
                if (l2 == null) {
                    return -1;
                }
                return l.compareTo(l2);
            }
        }
        ,
        BY_USERNAME{

            @Override
            public int compare(MemberAccountPermission memberAccountPermission, MemberAccountPermission memberAccountPermission2) {
                AccountInfo accountInfo = memberAccountPermission.getAccountInfo();
                AccountInfo accountInfo2 = memberAccountPermission2.getAccountInfo();
                if (accountInfo == null) {
                    return accountInfo2 == null ? 0 : 1;
                }
                if (accountInfo2 == null) {
                    return -1;
                }
                if (accountInfo.getUsername() == null) {
                    return accountInfo2.getUsername() == null ? 0 : 1;
                }
                if (accountInfo2.getUsername() == null) {
                    return -1;
                }
                return accountInfo.getUsername().compareTo(accountInfo2.getUsername());
            }
        }
        ,
        BY_DISPLAY_NAME{

            @Override
            public int compare(MemberAccountPermission memberAccountPermission, MemberAccountPermission memberAccountPermission2) {
                AccountInfo accountInfo = memberAccountPermission.getAccountInfo();
                AccountInfo accountInfo2 = memberAccountPermission2.getAccountInfo();
                if (accountInfo == null) {
                    return accountInfo2 == null ? 0 : 1;
                }
                if (accountInfo2 == null) {
                    return -1;
                }
                if (accountInfo.getDisplayName() == null) {
                    return accountInfo2.getDisplayName() == null ? 0 : 1;
                }
                if (accountInfo2.getDisplayName() == null) {
                    return -1;
                }
                return accountInfo.getDisplayName().compareTo(accountInfo2.getDisplayName());
            }
        }
        ,
        BY_PERMISSION{

            @Override
            public int compare(MemberAccountPermission memberAccountPermission, MemberAccountPermission memberAccountPermission2) {
                FolderPermission folderPermission = memberAccountPermission.getPermission();
                FolderPermission folderPermission2 = memberAccountPermission2.getPermission();
                if (folderPermission == null) {
                    return folderPermission2 == null ? 0 : -1;
                }
                if (folderPermission2 == null) {
                    return 1;
                }
                return folderPermission.getName().compareTo(folderPermission2.getName());
            }
        };


        @Override
        public int compare(MemberAccountPermission memberAccountPermission, MemberAccountPermission memberAccountPermission2) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

