/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.pro.E;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.net.AbstractAcceptor;
import de.dal33t.powerfolder.net.AbstractUDTSocketConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.net.UDTSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class J
extends PFComponent {
    private volatile boolean \u0107;
    private Thread \u0109;
    private UDTSocket \u010a;
    private int \u0108;
    private String \u010b;

    public J(Controller controller, int n, String string) {
        super(controller);
        this.\u0108 = n < 0 ? 1337 : n;
        this.\u010b = string;
    }

    public void \u00e6() throws ConnectionException {
        if (this.\u0108 == 1337) {
            this.logFine("Shutting down broadcast manager to avoid conflict on UDP port " + this.\u0108);
            if (this.getController().getBroadcastManager() != null) {
                this.getController().getBroadcastManager().shutdown();
            }
        }
        if (!this.\u00e8()) {
            this.\u00e9();
        }
        this.\u0107 = true;
        this.\u0109 = new Thread((Runnable)new _B(), "Listener (UDT) on port " + this.\u0108);
        this.\u0109.setPriority(1);
        this.\u0109.start();
    }

    public void \u00e5() {
        this.\u0107 = false;
        if (this.\u0109 != null) {
            this.\u0109.interrupt();
        }
        if (this.\u010a != null) {
            try {
                this.\u010a.close();
            }
            catch (IOException iOException) {
                this.logFiner(iOException.toString());
            }
        }
        this.logFine("Stopped");
    }

    public int \u00e7() {
        return this.\u010a != null ? this.\u010a.getLocalAddress().getPort() : this.\u0108;
    }

    public InetSocketAddress \u00e4() {
        return this.\u010a != null ? this.\u010a.getLocalAddress() : null;
    }

    private void \u00e9() throws ConnectionException {
        try {
            this.logFine("Opening UDT socket for incoming connections on port " + this.\u0108);
            String string = this.\u010b;
            InetAddress inetAddress = null;
            if (string != null && !StringUtils.isBlank(string)) {
                try {
                    inetAddress = InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    this.logInfo("Bad BIND address: " + string);
                    string = null;
                }
            }
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.\u0108);
            this.\u010a = new UDTSocket();
            this.\u010a.bind(inetSocketAddress);
            this.\u010a.listen(100);
        }
        catch (IOException iOException) {
            throw new ConnectionException(Translation.get("dialog.unable_to_open_port", "" + this.\u0108), iOException);
        }
        this.logInfo("Listening for incoming UDT connections on port " + this.\u0108);
    }

    private boolean \u00e8() {
        return this.\u010a != null && !this.\u010a.isClosed();
    }

    private class _B
    implements Runnable {
        private _B() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted() && J.this.\u0107) {
                try {
                    if (J.this.isFiner()) {
                        J.this.logFiner("Listening for new connections on " + J.this.\u010a);
                    }
                    UDTSocket uDTSocket = J.this.\u010a.accept();
                    boolean bl = true;
                    if (J.this.getController().isLanOnly()) {
                        bl = J.this.getController().getNodeManager().isOnLANorConfiguredOnLAN(uDTSocket.getRemoteAddress().getAddress());
                    }
                    if (!bl) {
                        uDTSocket.close();
                        continue;
                    }
                    if (J.this.isFiner()) {
                        J.this.logFiner("Incoming connection from: " + uDTSocket.getRemoteAddress().getAddress() + ":" + uDTSocket.getRemoteAddress().getPort());
                    }
                    J.this.getController().getNodeManager().acceptConnectionAsynchron(new _A(uDTSocket));
                }
                catch (SocketException socketException) {
                    J.this.logFine("Socket on port " + J.this.\u0108 + " closed");
                    break;
                }
                catch (IOException iOException) {
                    if (!J.this.\u0107) {
                        J.this.logFine("Socket on port " + J.this.\u0108 + " closed");
                        break;
                    }
                    J.this.logSevere("Exception while accepting socket: " + iOException, iOException);
                }
                catch (RuntimeException runtimeException) {
                    J.this.logSevere("Exception while accepting socket: " + runtimeException, runtimeException);
                }
            }
        }
    }

    private class _A
    extends AbstractAcceptor {
        private UDTSocket \u0145;

        private _A(UDTSocket uDTSocket) {
            super(J.this.getController());
            Reject.ifNull(uDTSocket, "Socket is null");
            this.\u0145 = uDTSocket;
        }

        @Override
        public String getConnectionInfo() {
            return this.\u0145.getRemoteAddress().toString();
        }

        @Override
        protected void accept() throws ConnectionException {
            if (this.isFiner()) {
                this.logFiner("Accepting UDT connection: " + this.\u0145);
            }
            AbstractUDTSocketConnectionHandler abstractUDTSocketConnectionHandler = this.getController().getIOProvider().getConnectionHandlerFactory().createAndInitUDTSocketConnectionHandler(this.\u0145);
            this.acceptConnection(abstractUDTSocketConnectionHandler);
        }

        @Override
        protected void shutdown() {
            try {
                this.\u0145.close();
            }
            catch (IOException iOException) {
                this.logFiner("Unable to close socket from acceptor", iOException);
            }
        }
    }
}

