/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.plugin;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.plugin.Plugin;
import de.dal33t.powerfolder.plugin.PluginEvent;
import de.dal33t.powerfolder.plugin.PluginManagerListener;
import de.dal33t.powerfolder.plugin.PluginWrapper;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PluginManager
extends PFComponent {
    private static final Logger log = Logger.getLogger(PluginManager.class.getName());
    private static final String OLD_WEBINTERFACE_PLUGIN_CLASS_NAME = "de.dal33t.powerfolder.AB";
    private static final String PLUGIN_PACKAGE_PREFIX = "de.dal33t.powerfolder.";
    private List<Plugin> plugins = new CopyOnWriteArrayList<Plugin>();
    private List<Plugin> disabledPlugins = new CopyOnWriteArrayList<Plugin>();
    private PluginManagerListener listeners = ListenerSupportFactory.createListenerSupport(PluginManagerListener.class);

    public PluginManager(Controller controller) {
        super(controller);
    }

    public void init() {
        this.readEnabledPlugins();
        this.readDisabledPlugins();
    }

    public void start() {
        if (this.plugins.size() + this.disabledPlugins.size() == 0) {
            this.logFine("No plugins found to start. Maybe PluginManager not initialized?");
        }
        this.startEnabledPlugins();
    }

    public void shutdown() {
        if (this.plugins != null) {
            for (Plugin plugin : this.plugins) {
                try {
                    plugin.stop();
                    plugin.destroy();
                }
                catch (Exception exception) {
                    this.logSevere("Exception while stopping/destroying plugin: " + plugin + ". " + exception, exception);
                }
                this.logFine(plugin.getName() + " stopped and destroyed");
            }
            this.plugins.clear();
        }
        if (this.disabledPlugins != null) {
            for (Plugin plugin : this.disabledPlugins) {
                try {
                    plugin.destroy();
                }
                catch (Exception exception) {
                    this.logSevere("Exception while destroying plugin: " + plugin + ". " + exception, exception);
                }
                this.logFine(plugin.getName() + " destroyed");
            }
            this.disabledPlugins.clear();
        }
    }

    private void readEnabledPlugins() {
        this.readAndInitPlugins(ConfigurationEntry.PLUGINS.getValue(this.getController()), this.plugins, "enabled");
    }

    private void readDisabledPlugins() {
        this.readAndInitPlugins(ConfigurationEntry.PLUGINS_DISABLED.getValue(this.getController()), this.disabledPlugins, "disabled");
    }

    private void readAndInitPlugins(String string, List<Plugin> list, String string2) {
        list.clear();
        if (StringUtils.isBlank(string)) {
            return;
        }
        boolean bl = string.contains(PLUGIN_PACKAGE_PREFIX);
        if (bl) {
            string = string.replaceAll(PLUGIN_PACKAGE_PREFIX, "");
        }
        this.logFine("Initalizing (" + string2 + ") plugins: " + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            Plugin plugin;
            String string3 = stringTokenizer.nextToken().trim();
            if (StringUtils.isBlank(string3) || this.alreadyLoaded(string3) || (plugin = this.newPluginInstance(string3)) == null) continue;
            list.add(plugin);
            plugin.init();
        }
        if (bl) {
            this.saveConfig();
        }
    }

    private Plugin newPluginInstance(String object) {
        if (StringUtils.isBlank((String)object)) {
            throw new IllegalArgumentException("Plugin string blank");
        }
        if (OLD_WEBINTERFACE_PLUGIN_CLASS_NAME.equalsIgnoreCase((String)object)) {
            this.logFine("Not loading web interface. It not longer available in v4.0 of PowerFolder.");
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            this.logFine("Initializing plugin: " + (String)object);
        }
        try {
            Plugin plugin;
            if (!((String)object).contains(".")) {
                object = PLUGIN_PACKAGE_PREFIX + (String)object;
            }
            Class<?> clazz = Class.forName((String)object);
            try {
                Constructor<?> constructor = clazz.getConstructor(Controller.class);
                plugin = (Plugin)constructor.newInstance(this.getController());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    plugin = (Plugin)clazz.newInstance();
                }
                catch (ClassCastException classCastException) {
                    log.log(Level.SEVERE, "failed to load: " + (String)object + "does not extends AbstractPFPlugin or implements Plugin", noSuchMethodException);
                    return null;
                }
            }
            return plugin;
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.log(Level.SEVERE, "Unable to initializing plugin. Class not found: '" + (String)object + "'");
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception while initializing plugin '" + (String)object + "'", exception);
        }
        return null;
    }

    private void startEnabledPlugins() {
        for (Plugin plugin : this.plugins) {
            this.logFine("Starting plugin: " + plugin.getName());
            try {
                plugin.start();
            }
            catch (Exception exception) {
                this.logSevere("Exception while starting plugin: " + plugin + ". " + exception, exception);
            }
        }
    }

    public boolean isEnabled(Plugin plugin) {
        if (plugin == null) {
            return false;
        }
        for (Plugin plugin2 : this.plugins) {
            PluginWrapper pluginWrapper;
            if (plugin2.equals(plugin)) {
                return true;
            }
            if (!(plugin2 instanceof PluginWrapper) || !(pluginWrapper = (PluginWrapper)plugin2).getDeligate().equals(plugin)) continue;
            return true;
        }
        return false;
    }

    public void setEnabled(Plugin plugin, boolean bl) {
        Plugin plugin2 = this.findPlugin(plugin);
        String string = plugin2.getClass().getName();
        int n = string.lastIndexOf(46);
        string = string.substring(n + 1);
        this.logFine("enable: " + bl + " " + string);
        if (bl) {
            this.disabledPlugins.remove(plugin2);
            if (!this.plugins.contains(plugin2)) {
                this.plugins.add(plugin2);
            }
            try {
                plugin2.start();
            }
            catch (Exception exception) {
                this.logSevere("Exception while starting plugin: " + string + ". " + exception, exception);
            }
        } else {
            this.plugins.remove(plugin2);
            if (!this.disabledPlugins.contains(plugin2)) {
                this.disabledPlugins.add(plugin2);
            }
            try {
                plugin2.stop();
            }
            catch (Exception exception) {
                this.logSevere("Exception while stopping plugin: " + string + ". " + exception, exception);
            }
        }
        this.saveConfig();
        this.firePluginStatusChange(plugin2);
    }

    public void saveConfig() {
        Object object = "";
        String string = "";
        String string2 = "";
        for (Plugin object2 : this.plugins) {
            string2 = object2.getClass().getName();
            if (string2.startsWith(PLUGIN_PACKAGE_PREFIX)) {
                int plugin = string2.lastIndexOf(46);
                string2 = string2.substring(plugin + 1);
            }
            object = (String)object + string + string2;
            string = ",";
        }
        ConfigurationEntry.PLUGINS.setValue(this.getController(), (String)object);
        Object object3 = "";
        string = "";
        for (Plugin plugin : this.disabledPlugins) {
            string2 = plugin.getClass().getName();
            if (string2.startsWith(PLUGIN_PACKAGE_PREFIX)) {
                int n = string2.lastIndexOf(46);
                string2 = string2.substring(n + 1);
            }
            object3 = (String)object3 + string + string2;
            string = ",";
        }
        ConfigurationEntry.PLUGINS_DISABLED.setValue(this.getController(), (String)object3);
        this.getController().saveConfig();
    }

    public List<Plugin> getPlugins() {
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        arrayList.addAll(this.plugins);
        arrayList.addAll(this.disabledPlugins);
        return arrayList;
    }

    public int countPlugins() {
        return this.plugins.size() + this.disabledPlugins.size();
    }

    public Plugin findPlugin(Plugin plugin) {
        Reject.ifNull(plugin, "searchPlugin");
        for (Plugin plugin2 : this.plugins) {
            if (plugin.equals(plugin2)) {
                return plugin2;
            }
            if (!(plugin2 instanceof PluginWrapper) || !((PluginWrapper)plugin2).getDeligate().equals(plugin)) continue;
            return plugin2;
        }
        for (Plugin plugin2 : this.disabledPlugins) {
            if (plugin.equals(plugin2)) {
                return plugin2;
            }
            if (!(plugin2 instanceof PluginWrapper) || !((PluginWrapper)plugin2).getDeligate().equals(plugin)) continue;
            return plugin2;
        }
        return plugin;
    }

    public Plugin findPluginByClass(Class<?> clazz) {
        Reject.ifNull(clazz, "Clazz is null");
        for (Plugin plugin : this.plugins) {
            if (plugin instanceof PluginWrapper) {
                plugin = ((PluginWrapper)plugin).getDeligate();
            }
            if (!clazz.isInstance(plugin)) continue;
            return plugin;
        }
        for (Plugin plugin : this.disabledPlugins) {
            if (plugin instanceof PluginWrapper) {
                plugin = ((PluginWrapper)plugin).getDeligate();
            }
            if (!clazz.isInstance(plugin)) continue;
            return plugin;
        }
        return null;
    }

    public void addPluginManagerListener(PluginManagerListener pluginManagerListener) {
        ListenerSupportFactory.addListener(this.listeners, pluginManagerListener);
    }

    public void removePluginManagerListener(PluginManagerListener pluginManagerListener) {
        ListenerSupportFactory.removeListener(this.listeners, pluginManagerListener);
    }

    private void firePluginStatusChange(Plugin plugin) {
        this.listeners.pluginStatusChanged(new PluginEvent(this, plugin));
    }

    private boolean alreadyLoaded(String string) {
        for (Plugin plugin : this.plugins) {
            if (!plugin.getClass().getName().equals(string)) continue;
            return true;
        }
        for (Plugin plugin : this.disabledPlugins) {
            if (!plugin.getClass().getName().equals(string)) continue;
            return true;
        }
        return false;
    }
}

