/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.net.AbstractUDTSocketConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.util.ByteSerializer;
import de.dal33t.powerfolder.util.net.UDTSocket;
import java.io.IOException;

public class PlainUDTSocketConnectionHandler
extends AbstractUDTSocketConnectionHandler
implements ConnectionHandler {
    protected PlainUDTSocketConnectionHandler(Controller controller, UDTSocket uDTSocket) {
        super(controller, uDTSocket);
    }

    @Override
    protected Object deserialize(byte[] byArray, int n) throws ClassNotFoundException, ConnectionException {
        boolean bl;
        boolean bl2 = bl = !this.isOnLAN();
        if (this.getIdentity() != null && this.getIdentity().isUseCompressedStream() != null) {
            bl = this.getIdentity().isUseCompressedStream();
        }
        try {
            return ByteSerializer.deserializeStatic(byArray, bl);
        }
        catch (IOException iOException) {
            throw new ConnectionException("Unable to send message to peer, connection closed", iOException).with(this);
        }
    }

    @Override
    protected byte[] serialize(Message message) throws ConnectionException {
        try {
            return this.getSerializer().serialize(message, this.getMyIdentity().isUseCompressedStream(), -1);
        }
        catch (IOException iOException) {
            throw new ConnectionException("Unable to send message to peer, connection closed", iOException).with(this);
        }
    }

    @Override
    protected Identity createOwnIdentity() {
        return new Identity(this.getController(), this.getController().getMySelf().getInfo(), this.getMyMagicId(), false, false, this);
    }
}

