/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.net.DynDns;
import de.dal33t.powerfolder.net.DynDnsManager;
import de.dal33t.powerfolder.net.DynDnsUpdateData;
import de.dal33t.powerfolder.net.ErrorInfo;
import de.dal33t.powerfolder.net.ErrorManager;
import de.dal33t.powerfolder.util.Base64;
import de.dal33t.powerfolder.util.StringUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DynDnsOrg
extends PFComponent
implements DynDns {
    private static final int GOOD = 0;
    private static final int NOCHG = 1;
    private static final int BADSYS = 2;
    private static final int BADAGENT = 3;
    private static final int BADAUTH = 4;
    private static final int NOTDONATOR = 5;
    private static final int NOTFQDN = 6;
    private static final int NOHOST = 7;
    private static final int NOTYOURS = 8;
    private static final int ABUSE = 9;
    private static final int NUMHOST = 10;
    private static final int DNSERR = 11;
    private static final int NINE11 = 12;
    private ErrorManager errManager = new ErrorManager();
    private DynDnsManager manager;
    private String serverResp;
    private int result;

    public DynDnsOrg(Controller controller) {
        super(controller);
        this.errManager.errors.put("good", new ErrorInfo("good", 0, 0, "The update was successful, and the hostname is now updated."));
        this.errManager.errors.put("nochg", new ErrorInfo("nochg", 1, 1, "The update changed no settings, and is considered abusive. Additional updates will cause the hostname to become blocked."));
        this.errManager.errors.put("badsys", new ErrorInfo("badsys", 2, 2, "The system parameter given is not valid. Valid system parameters are dyndns, statdns and custom"));
        this.errManager.errors.put("badagent", new ErrorInfo("badagent", 3, 2, "The user agent that was sent has been blocked for not following these specifications or no user agent was specified"));
        this.errManager.errors.put("badauth", new ErrorInfo("badauth", 4, 2, "The username or password specified are incorrect."));
        this.errManager.errors.put("!donator", new ErrorInfo("!donator", 5, 2, "An option available only to credited users (such as offline URL)was specified, but the user is not a credited user"));
        this.errManager.errors.put("notfqdn", new ErrorInfo("notfqdn", 6, 2, "The hostname specified is not a fully-qualified domain name (not in the form hostname.dyndns.org or domain.com)"));
        this.errManager.errors.put("nohost", new ErrorInfo("nohost", 7, 2, "The hostname specified does not exist (or is not in the service specified in the system parameter)."));
        this.errManager.errors.put("!yours", new ErrorInfo("!yours", 8, 2, "The hostname specified exists, but not under the username specified."));
        this.errManager.errors.put("abuse", new ErrorInfo("abuse", 9, 2, "The hostname specified is blocked for update abuse."));
        this.errManager.errors.put("numhost", new ErrorInfo("numhost", 10, 2, "Too many or too few hosts found."));
        this.errManager.errors.put("dnserr", new ErrorInfo("dnserr", 11, 2, "DNS error encountered."));
        this.errManager.errors.put("911", new ErrorInfo("911", 12, 2, "There is a serious problem on our side, such as a database or DNS server failure. The client should stop updating until notified via the status page that the service is back up."));
    }

    @Override
    public DynDnsUpdateData getDynDnsUpdateData() {
        DynDnsUpdateData dynDnsUpdateData = new DynDnsUpdateData();
        this.manager.fillDefaultUpdateData(dynDnsUpdateData);
        return dynDnsUpdateData;
    }

    @Override
    public void setDynDnsManager(DynDnsManager dynDnsManager) {
        this.manager = dynDnsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(DynDnsUpdateData dynDnsUpdateData) {
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        Pattern pattern = null;
        Matcher matcher = null;
        String string = dynDnsUpdateData.host;
        String string2 = "members.dyndns.org";
        String string3 = dynDnsUpdateData.ipAddress;
        String string4 = dynDnsUpdateData.username + ":" + dynDnsUpdateData.pass;
        byte[] byArray = string4.getBytes();
        String[] stringArray = new String[]{"good", "nochg", "badsys", "badagent", "badauth", "notdonator", "notfqdn", "nohost", "notyours", "abuse", "numhost", "dnserr", "nine11"};
        String string5 = "GET /nic/update?system=dyndns&hostname=" + string + "&myip=" + string3 + "&wildcard=ON&offline=NO HTTP/1.1\r\nHost: members.dyndns.org\r\nAuthorization: Basic " + Base64.encodeBytes(byArray) + "\r\nUser-Agent: .net dyndns client\r\n\r\n";
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string2, 80);
            Charset charset = Charset.forName("ISO-8859-1");
            CharsetDecoder charsetDecoder = charset.newDecoder();
            CharsetEncoder charsetEncoder = charset.newEncoder();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1024);
            CharBuffer charBuffer = CharBuffer.allocate(1024);
            abstractInterruptibleChannel = SocketChannel.open();
            ((SocketChannel)abstractInterruptibleChannel).connect(inetSocketAddress);
            ((SocketChannel)abstractInterruptibleChannel).write(charsetEncoder.encode(CharBuffer.wrap(string5)));
            this.serverResp = "";
            while (((SocketChannel)abstractInterruptibleChannel).read(byteBuffer) != -1) {
                byteBuffer.flip();
                charsetDecoder.decode(byteBuffer, charBuffer, false);
                charBuffer.flip();
                byteBuffer.clear();
            }
            this.logFiner("DynDns update result" + charBuffer);
            for (int i = 0; i < stringArray.length; ++i) {
                pattern = Pattern.compile(stringArray[i]);
                matcher = pattern.matcher(charBuffer.toString());
                if (!matcher.find()) continue;
                this.serverResp = charBuffer.toString().substring(matcher.start(), matcher.end());
                this.result = this.errManager.getType(this.serverResp);
                break;
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.logWarning(" " + unknownHostException.toString());
        }
        catch (IOException iOException) {
            this.logWarning(" " + iOException.toString());
        }
        finally {
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.result;
    }

    @Override
    public String getErrorShortText() {
        int n = !StringUtils.isBlank(this.serverResp) ? this.errManager.getCode(this.serverResp) : -1;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return this.errManager.getShortText(this.serverResp).toUpperCase();
            }
        }
        return "Unknown result from dyndns service";
    }

    @Override
    public String getErrorText() {
        int n = !StringUtils.isBlank(this.serverResp) ? this.errManager.getCode(this.serverResp) : -1;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return this.errManager.getText(this.serverResp);
            }
        }
        return "Unknown result from dyndns service";
    }
}

