/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DRequestMessage;
import de.dal33t.powerfolder.d2d.D2DRequestToServer;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.protocol.ShareLinkListRequestProto;
import de.dal33t.powerfolder.util.StringUtils;

public class ShareLinkListRequest
extends D2DRequestMessage
implements D2DRequestToServer {
    private String folderId;

    public ShareLinkListRequest() {
    }

    public ShareLinkListRequest(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public String getFolderId() {
        return this.folderId;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof ShareLinkListRequestProto.ShareLinkListRequest) {
            ShareLinkListRequestProto.ShareLinkListRequest shareLinkListRequest = (ShareLinkListRequestProto.ShareLinkListRequest)abstractMessage;
            this.requestCode = shareLinkListRequest.getRequestCode();
            this.folderId = shareLinkListRequest.getFolderId();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        ShareLinkListRequestProto.ShareLinkListRequest.Builder builder = ShareLinkListRequestProto.ShareLinkListRequest.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.requestCode != null) {
            builder.setRequestCode(this.requestCode);
        }
        if (this.folderId != null) {
            builder.setFolderId(this.folderId);
        }
        return builder.build();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && StringUtils.isNotBlank(this.folderId);
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.SHARE_LINK_LIST_REQUEST;
    }
}

