/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.d2d.D2DRequestMessage;
import de.dal33t.powerfolder.d2d.D2DRequestToServer;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.GroupInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.protocol.AccountInfoProto;
import de.dal33t.powerfolder.protocol.GroupInfoProto;
import de.dal33t.powerfolder.protocol.InvitationCreateRequestProto;
import de.dal33t.powerfolder.protocol.NodeInfoProto;
import de.dal33t.powerfolder.protocol.PermissionInfoProto;
import de.dal33t.powerfolder.security.AdminPermission;
import de.dal33t.powerfolder.security.ChangePreferencesPermission;
import de.dal33t.powerfolder.security.ChangeTransferModePermission;
import de.dal33t.powerfolder.security.ComputersAppPermission;
import de.dal33t.powerfolder.security.ConfigAppPermission;
import de.dal33t.powerfolder.security.FolderAdminPermission;
import de.dal33t.powerfolder.security.FolderCreatePermission;
import de.dal33t.powerfolder.security.FolderOwnerPermission;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.FolderReadPermission;
import de.dal33t.powerfolder.security.FolderReadWritePermission;
import de.dal33t.powerfolder.security.FolderRemovePermission;
import de.dal33t.powerfolder.security.GroupAdminPermission;
import de.dal33t.powerfolder.security.OrganizationAdminPermission;
import de.dal33t.powerfolder.security.OrganizationCreatePermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.security.SingletonPermission;
import de.dal33t.powerfolder.security.SystemSettingsPermission;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class InvitationCreateRequest
extends D2DRequestMessage
implements D2DRequestToServer {
    private static final Logger LOG = Logger.getLogger(InvitationCreateRequest.class.getName());
    protected Collection<Permission> permissions;
    protected Collection<D2DObject> subjects;

    public InvitationCreateRequest() {
    }

    public InvitationCreateRequest(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public Collection<Permission> getPermissions() {
        return this.permissions;
    }

    public Collection<D2DObject> getSubjects() {
        return this.subjects;
    }

    protected PermissionInfoProto.PermissionInfo getPermissionInfo() {
        if (this.permissions != null && this.permissions.size() == 1) {
            Permission permission = this.permissions.iterator().next();
            if (permission instanceof FolderPermission) {
                return (PermissionInfoProto.PermissionInfo)((FolderPermission)permission).toD2D();
            }
            if (permission instanceof GroupAdminPermission) {
                return (PermissionInfoProto.PermissionInfo)((GroupAdminPermission)permission).toD2D();
            }
            if (permission instanceof OrganizationAdminPermission) {
                return (PermissionInfoProto.PermissionInfo)((OrganizationAdminPermission)permission).toD2D();
            }
            if (permission instanceof SingletonPermission) {
                return (PermissionInfoProto.PermissionInfo)((SingletonPermission)permission).toD2D();
            }
        }
        return null;
    }

    protected void setPermissionInfo(PermissionInfoProto.PermissionInfo permissionInfo) {
        this.permissions = new CopyOnWriteArrayList<Permission>();
        switch (permissionInfo.getPermissionType()) {
            case ADMIN: {
                this.permissions.add(new AdminPermission(permissionInfo));
                break;
            }
            case CHANGE_PREFERENCES: {
                this.permissions.add(new ChangePreferencesPermission(permissionInfo));
                break;
            }
            case CHANGE_TRANSFER_MODE: {
                this.permissions.add(new ChangeTransferModePermission(permissionInfo));
                break;
            }
            case COMPUTERS_APP: {
                this.permissions.add(new ComputersAppPermission(permissionInfo));
                break;
            }
            case CONFIG_APP: {
                this.permissions.add(new ConfigAppPermission(permissionInfo));
                break;
            }
            case FOLDER_ADMIN: {
                this.permissions.add(new FolderAdminPermission(permissionInfo));
                break;
            }
            case FOLDER_CREATE: {
                this.permissions.add(new FolderCreatePermission(permissionInfo));
                break;
            }
            case FOLDER_OWNER: {
                this.permissions.add(new FolderOwnerPermission(permissionInfo));
                break;
            }
            case FOLDER_READ: {
                this.permissions.add(new FolderReadPermission(permissionInfo));
                break;
            }
            case FOLDER_READ_WRITE: {
                this.permissions.add(new FolderReadWritePermission(permissionInfo));
                break;
            }
            case FOLDER_REMOVE: {
                this.permissions.add(new FolderRemovePermission(permissionInfo));
                break;
            }
            case GROUP_ADMIN: {
                this.permissions.add(new GroupAdminPermission(permissionInfo));
                break;
            }
            case ORGANIZATION_ADMIN: {
                this.permissions.add(new OrganizationAdminPermission(permissionInfo));
                break;
            }
            case ORGANIZATION_CREATE: {
                this.permissions.add(new OrganizationCreatePermission(permissionInfo));
                break;
            }
            case SYSTEM_SETTINGS: {
                this.permissions.add(new SystemSettingsPermission(permissionInfo));
                break;
            }
            case UNRECOGNIZED: {
                break;
            }
        }
        if (permissionInfo.getSubjectsCount() == 1) {
            this.subjects = new CopyOnWriteArrayList<D2DObject>();
            try {
                Any any = permissionInfo.getSubjects(0);
                String string = any.getTypeUrl().split("/")[1];
                if (string.equals("AccountInfo")) {
                    AccountInfoProto.AccountInfo accountInfo = any.unpack(AccountInfoProto.AccountInfo.class);
                    this.subjects.add(new AccountInfo(accountInfo));
                } else if (string.equals("GroupInfo")) {
                    GroupInfoProto.GroupInfo groupInfo = any.unpack(GroupInfoProto.GroupInfo.class);
                    this.subjects.add(new GroupInfo(groupInfo));
                } else if (string.equals("NodeInfo")) {
                    NodeInfoProto.NodeInfo nodeInfo = any.unpack(NodeInfoProto.NodeInfo.class);
                    this.subjects.add(new MemberInfo(nodeInfo));
                }
            }
            catch (InvalidProtocolBufferException | NullPointerException exception) {
                LOG.severe("Cannot unpack message: " + exception);
            }
        }
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof InvitationCreateRequestProto.InvitationCreateRequest) {
            InvitationCreateRequestProto.InvitationCreateRequest invitationCreateRequest = (InvitationCreateRequestProto.InvitationCreateRequest)abstractMessage;
            this.requestCode = invitationCreateRequest.getRequestCode();
            this.setPermissionInfo(invitationCreateRequest.getPermissionInfo());
        }
    }

    @Override
    public AbstractMessage toD2D() {
        InvitationCreateRequestProto.InvitationCreateRequest.Builder builder = InvitationCreateRequestProto.InvitationCreateRequest.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.requestCode != null) {
            builder.setRequestCode(this.requestCode);
        }
        if (this.permissions != null) {
            builder.setPermissionInfo(this.getPermissionInfo());
        }
        return builder.build();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.permissions != null && this.subjects != null;
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.INVITATION_CREATE_REQUEST;
    }
}

