/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import de.dal33t.powerfolder.StatusCode;
import de.dal33t.powerfolder.d2d.D2DReplyFromServer;
import de.dal33t.powerfolder.d2d.D2DReplyMessage;
import de.dal33t.powerfolder.protocol.AvatarReplyProto;

public class AvatarReply
extends D2DReplyMessage
implements D2DReplyFromServer {
    public byte[] data;

    public AvatarReply() {
    }

    public AvatarReply(String string, StatusCode statusCode) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
    }

    public AvatarReply(String string, StatusCode statusCode, byte[] byArray) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
        this.data = byArray;
    }

    public AvatarReply(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof AvatarReplyProto.AvatarReply) {
            AvatarReplyProto.AvatarReply avatarReply = (AvatarReplyProto.AvatarReply)abstractMessage;
            this.replyCode = avatarReply.getReplyCode();
            this.replyStatusCode = StatusCode.getEnum(avatarReply.getReplyStatusCode());
            this.data = avatarReply.getData().toByteArray();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        AvatarReplyProto.AvatarReply.Builder builder = AvatarReplyProto.AvatarReply.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.replyCode != null) {
            builder.setReplyCode(this.replyCode);
        }
        builder.setReplyStatusCode(this.replyStatusCode.getCode());
        if (this.data != null) {
            builder.setData(ByteString.copyFrom(this.data));
        }
        return builder.build();
    }
}

