/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DRequestMessage;
import de.dal33t.powerfolder.d2d.D2DRequestToServer;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.protocol.AccountChangeRequestProto;
import java.util.ArrayList;
import java.util.Collection;

public class AccountChangeRequest
extends D2DRequestMessage
implements D2DRequestToServer {
    private String firstname;
    private String surname;
    private String telephone;
    private Collection<String> emails;

    public String getFirstname() {
        return this.firstname;
    }

    public String getSurname() {
        return this.surname;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public Collection<String> getEmails() {
        return this.emails;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof AccountChangeRequestProto.AccountChangeRequest) {
            AccountChangeRequestProto.AccountChangeRequest accountChangeRequest = (AccountChangeRequestProto.AccountChangeRequest)abstractMessage;
            this.requestCode = accountChangeRequest.getRequestCode();
            this.firstname = accountChangeRequest.getFirstname();
            this.surname = accountChangeRequest.getSurname();
            this.telephone = accountChangeRequest.getTelephone();
            this.emails = new ArrayList<String>();
            this.emails.addAll(accountChangeRequest.getEmailsList());
        }
    }

    @Override
    public AbstractMessage toD2D() {
        AccountChangeRequestProto.AccountChangeRequest.Builder builder = AccountChangeRequestProto.AccountChangeRequest.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.requestCode != null) {
            builder.setRequestCode(this.requestCode);
        }
        if (this.firstname != null) {
            builder.setFirstname(this.firstname);
        }
        if (this.surname != null) {
            builder.setSurname(this.surname);
        }
        if (this.firstname != null) {
            builder.setFirstname(this.firstname);
        }
        if (this.emails != null) {
            for (String string : this.emails) {
                builder.addEmails(string);
            }
        }
        return builder.build();
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.ACCOUNT_CHANGE_REQUEST;
    }
}

