/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DEvent;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.protocol.PingProto;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.IdGenerator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Ping
extends Message
implements D2DObject,
D2DEvent {
    private static final long serialVersionUID = 100L;
    private static final int MESSAGE_VERSION = 100;
    long sendTime;
    byte[] payload;
    public String id;

    public Ping() {
        this(-1);
    }

    public Ping(int n) {
        if (n >= 0) {
            this.id = IdGenerator.makeId();
            this.payload = new byte[n];
            for (int i = 0; i < this.payload.length; ++i) {
                this.payload[i] = (byte)(Math.random() * 256.0);
            }
        } else {
            this.id = null;
            this.payload = null;
        }
    }

    public void sent() {
        this.sendTime = System.currentTimeMillis();
    }

    public String toString() {
        return "Ping" + (String)(this.payload != null ? " " + Format.formatBytes(this.payload.length) + " bytes payload" : "");
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n != 100) {
            throw new ClassNotFoundException("Incompatible class versions for " + this.getClass().getName() + ". remote version: " + n + ", own version: 100");
        }
        int n2 = objectInput.readInt();
        this.id = n2 >= 0 ? objectInput.readUTF() : null;
        int n3 = objectInput.readInt();
        if (n3 == -1) {
            this.payload = null;
        } else {
            this.payload = new byte[n3];
            objectInput.read(this.payload);
        }
        this.payload = (byte[])objectInput.readObject();
        this.sendTime = objectInput.readLong();
        objectInput.close();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(100);
        if (this.id != null) {
            objectOutput.write(this.id.length());
            objectOutput.writeUTF(this.id);
        } else {
            objectOutput.write(-1);
        }
        if (this.payload != null) {
            objectOutput.writeInt(this.payload.length);
            objectOutput.write(this.payload);
        } else {
            objectOutput.writeInt(-1);
        }
        objectOutput.writeLong(this.sendTime);
        objectOutput.close();
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof PingProto.Ping) {
            PingProto.Ping ping = (PingProto.Ping)abstractMessage;
            this.sendTime = ping.getSendTime();
            this.payload = ping.getPayload().getBytes();
            this.id = ping.getId();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        PingProto.Ping.Builder builder = PingProto.Ping.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        builder.setSendTime(this.sendTime);
        builder.setPayload(String.valueOf(this.payload));
        if (this.id != null) {
            builder.setId(this.id);
        }
        return builder.build();
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.PING;
    }
}

