/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.message.FolderList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class FolderListExt
extends FolderList
implements Externalizable {
    private static final long serialVersionUID = -3861676003458215175L;
    private static final long extVersionUID = 102L;
    private final long writeExtVersionUID;

    public FolderListExt() {
        this.writeExtVersionUID = 100L;
    }

    public FolderListExt(Collection<FolderInfo> collection, String string) {
        super(collection, string);
        this.writeExtVersionUID = 100L;
    }

    public FolderListExt(Collection<FolderInfo> collection, boolean bl) {
        super(collection);
        this.writeExtVersionUID = bl ? 102L : 101L;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        int n2;
        long l = objectInput.readLong();
        if (l != 102L && l != 101L && l != 100L) {
            throw new InvalidClassException(this.getClass().getName(), "Unable to read. extVersionUID(steam): " + l + ", supported: 102 and 100");
        }
        this.joinedMetaFolders = objectInput.readBoolean();
        if (objectInput.readBoolean()) {
            n2 = objectInput.readInt();
            this.secretFolders = new FolderInfo[n2];
            for (n = 0; n < this.secretFolders.length; ++n) {
                this.secretFolders[n] = FolderInfoFactory.lookupInstance(objectInput.readUTF());
            }
        }
        if (l >= 101L && objectInput.readBoolean()) {
            n2 = objectInput.readInt();
            this.folders = new FolderInfo[n2];
            for (n = 0; n < this.folders.length; ++n) {
                this.folders[n] = FolderInfo.readExt(objectInput);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.writeExtVersionUID);
        objectOutput.writeBoolean(this.joinedMetaFolders);
        objectOutput.writeBoolean(this.secretFolders != null);
        if (this.secretFolders != null) {
            objectOutput.writeInt(this.secretFolders.length);
            for (FolderInfo folderInfo : this.secretFolders) {
                objectOutput.writeUTF(folderInfo.id);
            }
        }
        if (this.writeExtVersionUID <= 100L) {
            return;
        }
        objectOutput.writeBoolean(this.folders != null);
        if (this.folders != null) {
            objectOutput.writeInt(this.folders.length);
            for (FolderInfo folderInfo : this.folders) {
                folderInfo.writeExternal(objectOutput, this.writeExtVersionUID == 102L);
            }
        }
    }
}

