/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.message.FolderRelatedMessage;
import de.dal33t.powerfolder.protocol.FileListRequestProto;
import de.dal33t.powerfolder.util.Reject;

public class FileListRequest
extends FolderRelatedMessage
implements D2DObject {
    private static final long serialVersionUID = 100L;

    public FileListRequest(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "Folder info is null");
        this.folder = folderInfo;
    }

    public String toString() {
        return "FileListRequest [folder=" + this.folder.getLocalizedName() + "/" + this.folder.id + "]";
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
    }

    @Override
    public AbstractMessage toD2D() {
        FileListRequestProto.FileListRequest.Builder builder = FileListRequestProto.FileListRequest.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.folder != null) {
            builder.setFolderId(this.folder.id);
        }
        builder.setRecursive(true);
        return builder.build();
    }
}

