/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.light;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.protocol.NodeInfoProto;
import de.dal33t.powerfolder.protocol.ServerInfoProto;
import de.dal33t.powerfolder.util.Base64;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class ServerInfo
implements Serializable,
D2DObject {
    private static final long serialVersionUID = 100L;
    public static final String PROPERTYNAME_ID = "id";
    public static final String PROPERTYNAME_NODE = "node";
    public static final String PROPERTYNAME_WEB_URL = "webUrl";
    public static final String PROPERTYNAME_LAST_UP_TIME = "lastUpTime";
    @Id
    private String id;
    @ManyToOne
    @JoinColumn(name="memberInfo_id")
    private MemberInfo node;
    private String webUrl;
    private String httpTunnelUrl;
    private String validationCode;
    private Date validationReceived;
    private Date validationSend;
    private String federationVersion;
    private Date lastUpTime;

    protected ServerInfo() {
    }

    private ServerInfo(MemberInfo memberInfo, String string, String string2) {
        this.node = memberInfo;
        this.webUrl = string;
        this.httpTunnelUrl = string2;
        if (memberInfo != null) {
            this.id = memberInfo.id;
        } else {
            Reject.ifBlank(string, "webUrl is blank");
            this.id = string = Util.removeLastSlashFromURI(string.toLowerCase());
        }
        this.federationVersion = "26.0";
        Reject.ifBlank(this.id, "Unable to set ID of ServerInfo");
    }

    public ServerInfo(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public static ServerInfo newClusterServer(MemberInfo memberInfo, String string, String string2) {
        return new ServerInfo(memberInfo, string, string2);
    }

    public static ServerInfo newFederatedService(String string, String string2) {
        return new ServerInfo(null, string, string2);
    }

    public boolean isClusterServer() {
        return this.node != null;
    }

    public boolean isFederatedService() {
        return this.node == null;
    }

    public MemberInfo getNode() {
        return this.node;
    }

    public void setNode(MemberInfo memberInfo) {
        Reject.ifNull(memberInfo, "Node is null");
        this.node = memberInfo;
        this.id = memberInfo.id;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public void setWebUrl(String string) {
        this.webUrl = string;
    }

    public String getURL(String string) {
        String string2 = this.webUrl;
        if (string2 == null) {
            string2 = "";
        }
        if (string == null) {
            return string2;
        }
        boolean bl = string.startsWith("/") || string2.endsWith("/") || StringUtils.isBlank(string);
        String string3 = bl ? "" : "/";
        return string2 + string3 + string;
    }

    public String getURL(FolderInfo folderInfo) {
        Object object = "/files/";
        String string = Base64.encode4URL(folderInfo.getId());
        if (string.endsWith("=")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.endsWith("=")) {
            string = string.substring(0, string.length() - 1);
        }
        object = (String)object + Util.encodeForURL(string);
        return this.getURL((String)object);
    }

    public String getHTTPTunnelUrl() {
        return this.httpTunnelUrl;
    }

    public URI getClientWebSocketURI() {
        if (this.webUrl == null) {
            return null;
        }
        String string = this.webUrl.replace("http://", "ws://").replace("https://", "wss://");
        try {
            return new URI(Util.removeLastSlashFromURI(string) + "/websocket_client/" + this.id);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public void setHTTPTunnelUrl(String string) {
        this.httpTunnelUrl = string;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        if (this.isFederatedService()) {
            return this.webUrl;
        }
        return this.node.getNick();
    }

    public void migrateId() {
        if (this.node != null) {
            this.id = this.node.id;
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.node == null ? 0 : this.node.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ServerInfo)) {
            return false;
        }
        ServerInfo serverInfo = (ServerInfo)object;
        if (this.id == null) {
            return serverInfo.id == null;
        }
        return this.id.equals(serverInfo.id);
    }

    public String toString() {
        if (this.isFederatedService()) {
            return "Federated service: " + this.webUrl;
        }
        return "Server " + this.node.nick + "/" + this.node.networkId + "/" + this.node.id + ", web: " + this.webUrl + ", tunnel: " + this.httpTunnelUrl;
    }

    public Date getValidationReceived() {
        return this.validationReceived;
    }

    public void setValidationReceived(Date date) {
        this.validationReceived = date;
    }

    public Date getValidationSend() {
        return this.validationSend;
    }

    public void setValidationSend(Date date) {
        this.validationSend = date;
    }

    public String getValidationCode() {
        return this.validationCode;
    }

    public void setValidationCode(String string) {
        this.validationCode = string;
    }

    public boolean isValidated() {
        return this.validationReceived != null && this.validationSend != null;
    }

    public Date getLastUpTime() {
        return this.lastUpTime;
    }

    public void setLastUpTime(Date date) {
        this.lastUpTime = date;
    }

    public void updateLastUpTime() {
        this.lastUpTime = new Date();
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof ServerInfoProto.ServerInfo) {
            ServerInfoProto.ServerInfo serverInfo = (ServerInfoProto.ServerInfo)abstractMessage;
            this.node = new MemberInfo(serverInfo.getNodeInfo());
            this.webUrl = serverInfo.getHttpUrl();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        ServerInfoProto.ServerInfo.Builder builder = ServerInfoProto.ServerInfo.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.node != null) {
            builder.setNodeInfo((NodeInfoProto.NodeInfo)this.node.toD2D());
        }
        if (this.webUrl != null) {
            builder.setHttpUrl(this.webUrl);
        }
        return builder.build();
    }

    public void setFederationVersion(String string) {
        this.federationVersion = string;
    }

    public String getFederationVersion() {
        return this.federationVersion;
    }
}

