/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.light;

import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.StackDump;
import java.nio.file.Path;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FolderInfoFactory {
    private static final Logger LOG = Logger.getLogger(FileInfoFactory.class.getName());

    private FolderInfoFactory() {
    }

    public static FolderInfo lookupInstance(String string) {
        return new FolderInfo("", string, -1, null);
    }

    public static FolderInfo lookupInstance(String string, String string2) {
        return new FolderInfo(string2, string, -1, null);
    }

    public static FolderInfo copyFrom(Folder folder) {
        return new FolderInfo(folder.getInfo().getName(), folder.getInfo().getId(), folder.getInfo().getVersion(), folder.getInfo().getParent());
    }

    public static FolderInfo newTopFolder(String string) {
        return new FolderInfo(string, IdGenerator.makeFolderId(), 0, null).intern();
    }

    public static FolderInfo newTopFolder(String string, String string2) {
        return new FolderInfo(string2, string, 0, null).intern();
    }

    public static FolderInfo newFolder(String string, DirectoryInfo directoryInfo) {
        return new FolderInfo(string, IdGenerator.makeFolderId(), 0, directoryInfo).intern();
    }

    public static FolderInfo newFolder(String string, String string2, DirectoryInfo directoryInfo) {
        return new FolderInfo(string2, string, 0, directoryInfo).intern();
    }

    public static FolderInfo proxyFolder(String string, String string2) {
        return new FolderInfo(string2, string, 0, null).intern();
    }

    public static FolderInfo backupFolderOfAccount(String string, AccountInfo accountInfo) {
        return new FolderInfo(string, "PB-" + accountInfo.getOID() + "-" + string, 0, null).intern();
    }

    public static FolderInfo unmarshallExistingTopFolder(String string, String string2, int n) {
        return new FolderInfo(string2, string, n, null).intern();
    }

    public static FolderInfo unmarshallExistingFolder(String string, String string2, int n, DirectoryInfo directoryInfo) {
        return new FolderInfo(string2, string, n, directoryInfo).intern();
    }

    public static FolderInfo resolveConflict(FolderInfo folderInfo) {
        int n;
        if (folderInfo.isLookupInstance()) {
            n = 0;
            LOG.log(Level.WARNING, folderInfo + ": Renaming from lookup instance is discouraged, but used.", new StackDump());
        } else {
            n = folderInfo.getVersion() + 1;
        }
        return new FolderInfo(folderInfo.getName(), folderInfo.getId(), n, folderInfo.getParent()).intern(true);
    }

    public static FolderInfo rename(FolderInfo folderInfo, String string) {
        int n;
        if (folderInfo.getName().equals(string)) {
            return folderInfo;
        }
        if (folderInfo.isLookupInstance()) {
            n = 0;
            LOG.log(Level.WARNING, folderInfo + ": Renaming from lookup instance is discouraged, but used.", new StackDump());
        } else {
            n = folderInfo.getVersion() + 1;
        }
        return new FolderInfo(string, folderInfo.getId(), n, folderInfo.getParent()).intern(true);
    }

    public static FolderInfo readFrom(Path path) {
        Path path2 = path.resolve(Constants.POWERFOLDER_SYSTEM_SUBDIR).resolve("FolderInfo");
        return FolderInfo.load(path2);
    }

    public static FolderInfo readFrom(Folder folder) {
        Path path = folder.getSystemSubDir().resolve("FolderInfo");
        return FolderInfo.load(path);
    }

    public static boolean writeFolderInfo(Folder folder) {
        Path path = folder.getSystemSubDir().resolve("FolderInfo");
        return folder.getInfo().save(path);
    }

    public static FolderInfo newRandomTopFolderForTest() {
        return FolderInfoFactory.unmarshallExistingTopFolder(IdGenerator.makeFolderId(), "TestFolder / " + UUID.randomUUID(), (int)(1000000.0 * Math.random()));
    }

    public static FolderInfo newTopFolderForTest(String string) {
        return new FolderInfo(string, IdGenerator.makeFolderId(), 0, null);
    }

    public static FolderInfo newTopFolderForTest(String string, String string2) {
        return new FolderInfo(string, string2, 0, null);
    }

    public static FolderInfo backupFolderOfAccountForTest(String string, AccountInfo accountInfo) {
        return FolderInfoFactory.backupFolderOfAccount(string, accountInfo);
    }
}

