/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.event;

import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.ScanResult;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.message.FileList;
import de.dal33t.powerfolder.message.FolderFilesChanged;
import de.dal33t.powerfolder.util.Reject;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;

public class FolderEvent
extends EventObject {
    private ScanResult scanResult;
    private FileList fileList;
    private FolderFilesChanged changeList;
    private Member member;
    private Collection<FileInfo> scannedFileInfos;
    private Collection<FileInfo> deletedFileInfos;
    private SyncProfile newSyncProfile;

    public FolderEvent(Folder folder) {
        super(folder);
    }

    public FolderEvent(Folder folder, ScanResult scanResult) {
        super(folder);
        Reject.ifNull(scanResult, "ScanResult is null");
        this.scanResult = scanResult;
    }

    public FolderEvent(Folder folder, FileList fileList, Member member) {
        super(folder);
        Reject.ifNull(fileList, "Filelist is null");
        this.fileList = fileList;
        this.member = member;
    }

    public FolderEvent(Folder folder, FolderFilesChanged folderFilesChanged, Member member) {
        super(folder);
        Reject.ifNull(folderFilesChanged, "ChangeList is null");
        this.changeList = folderFilesChanged;
        this.member = member;
    }

    public FolderEvent(Folder folder, FileInfo fileInfo) {
        this(folder, Collections.singleton(fileInfo), true);
    }

    public FolderEvent(Folder folder, Collection<FileInfo> collection, boolean bl) {
        super(folder);
        Reject.ifNull(collection, "FileInfo is null");
        if (bl) {
            this.scannedFileInfos = collection;
        } else {
            this.deletedFileInfos = collection;
        }
    }

    public FolderEvent(Folder folder, Collection<FileInfo> collection) {
        this(folder, collection, false);
    }

    public FolderEvent(Folder folder, SyncProfile syncProfile) {
        super(folder);
        Reject.ifNull(syncProfile, "New sync profile is null");
        this.newSyncProfile = syncProfile;
    }

    public Folder getFolder() {
        return (Folder)this.getSource();
    }

    public ScanResult getScanResult() {
        return this.scanResult;
    }

    public FileList getFileList() {
        return this.fileList;
    }

    public FolderFilesChanged getChangeList() {
        return this.changeList;
    }

    public Member getMember() {
        return this.member;
    }

    public Collection<FileInfo> getScannedFileInfos() {
        return this.scannedFileInfos;
    }

    public Collection<FileInfo> getDeletedFileInfos() {
        return this.deletedFileInfos;
    }

    public SyncProfile getNewSyncProfile() {
        return this.newSyncProfile;
    }
}

