/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.distribution;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.distribution.Standard;
import de.dal33t.powerfolder.util.ConfigurationLoader;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.Waiter;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class Hessenbox
extends Standard {
    @Override
    public void init(Controller controller) {
        super.init(controller);
        if (!OSUtil.isWindowsSystem()) {
            return;
        }
        try {
            Properties properties;
            Properties properties2 = this.loadFolderConfig("JLUBox");
            if (properties2 != null) {
                this.logInfo("Migrated JLUBox folder configuration");
                ConfigurationLoader.merge(properties2, controller);
                this.saveConfig(() -> this.deleteFolderConfig("JLUBox"));
            }
            if ((properties = this.loadFolderConfig("HESSENBOX-DA")) != null) {
                this.logInfo("Migrated HESSENBOX-DA folder configuration");
                ConfigurationLoader.merge(properties, controller);
                this.saveConfig(() -> this.deleteFolderConfig("HESSENBOX-DA"));
            }
        }
        catch (Exception exception) {
            this.logWarning("Migration of folder config failed. " + exception, exception);
        }
        try {
            this.startUninstallation("C:\\Program Files\\Universitaet Giessen\\JLUbox\\uninstall.exe");
            this.startUninstallation("C:\\Program Files (x86)\\Universitaet Giessen\\JLUbox\\uninstall.exe");
            this.startUninstallation("C:\\Program Files\\TU Darmstadt\\HESSENBOX_DA\\uninstall.exe");
            this.startUninstallation("C:\\Program Files (x86)\\TU Darmstadt\\HESSENBOX_DA\\uninstall.exe");
        }
        catch (Exception exception) {
            this.logWarning("Uninstallation of legacy client failed. " + exception, exception);
        }
    }

    private Properties loadFolderConfig(String string) {
        Properties properties;
        block9: {
            Path path = Path.of(WinUtils.getAppDataCurrentUser(), new String[0]).resolve(string).resolve("PowerFolder-Folder.config");
            if (Files.notExists(path, new LinkOption[0])) {
                return null;
            }
            Properties properties2 = new Properties();
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                properties2.load(inputStream);
                properties = properties2;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    this.logWarning("Could not read " + path.toString() + ". " + iOException.getMessage());
                    return null;
                }
            }
            inputStream.close();
        }
        return properties;
    }

    private void deleteFolderConfig(String string) {
        Path path = Path.of(WinUtils.getAppDataCurrentUser(), new String[0]).resolve(string).resolve("PowerFolder-Folder.config");
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            this.logWarning("Could not delete " + path.toString() + ". " + iOException.getMessage());
        }
    }

    private void startUninstallation(String string) {
        boolean bl = Files.exists(Path.of(string, new String[0]), new LinkOption[0]);
        if (!bl) {
            return;
        }
        this.logInfo("Starting uninstallation: " + string);
        try {
            File file = File.createTempFile("Elevate", ".cmd");
            file.delete();
            Util.copyResourceTo("Elevate.cmd", null, file.toPath(), false, true);
            String[] stringArray = new String[]{file.getAbsolutePath(), string};
            Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            this.logWarning("Exception while executing uninstallation: " + string + ". " + iOException, iOException);
        }
    }

    private void saveConfig(Runnable runnable) {
        if (this.getController().isStarted()) {
            this.getController().saveConfig();
            runnable.run();
        } else {
            this.getController().schedule(() -> {
                Waiter waiter = new Waiter(60000L);
                while (!waiter.isTimeout()) {
                    if (this.getController().isStarted()) {
                        this.getController().saveConfig();
                        runnable.run();
                        break;
                    }
                    waiter.waitABit();
                }
            }, 5000L);
        }
    }
}

