/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.problem;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.util.Translation;
import java.util.Date;

public class UnsynchronizedFolderProblem
extends ResolvableProblem {
    private Date lastSyncDate;
    private FolderInfo folderInfo;

    public UnsynchronizedFolderProblem(FolderInfo folderInfo, Date date) {
        this.folderInfo = folderInfo;
        this.lastSyncDate = date;
    }

    @Override
    public String getDescription() {
        long l = System.currentTimeMillis() - this.lastSyncDate.getTime();
        l /= 1000L;
        if ((l /= 60L) <= 59L) {
            return Translation.get("folder_problem.unsynchronized_minutes", this.folderInfo.getLocalizedName(), String.valueOf(l));
        }
        if ((l /= 60L) <= 23L) {
            return Translation.get("folder_problem.unsynchronized_hours", this.folderInfo.getLocalizedName(), String.valueOf(l));
        }
        return Translation.get("folder_problem.unsynchronized", this.folderInfo.getLocalizedName(), String.valueOf(l /= 24L));
    }

    @Override
    public String getWikiLinkKey() {
        return "Unsynchronized-Folder";
    }

    @Override
    public Folder getFolder(Controller controller) {
        return this.folderInfo.getFolder(controller);
    }

    @Override
    public String getResolutionDescription() {
        return Translation.get("folder_problem.unsynchronized.soln_desc");
    }

    @Override
    public Runnable resolution(final Controller controller) {
        return new Runnable(){

            @Override
            public void run() {
                controller.getUIController().openFilesInformationUnsynced(UnsynchronizedFolderProblem.this.folderInfo);
            }
        };
    }

    public String toString() {
        return this.getDescription() + ". lastSyncDate=" + this.lastSyncDate;
    }
}

