/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.problem;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import java.nio.file.Path;

public class FolderReadOnlyProblem
extends ResolvableProblem {
    private final Path path;
    private final boolean revertedOnly;
    private final Folder folder;

    public FolderReadOnlyProblem(Folder folder, Path path) {
        this(folder, path, false);
    }

    public FolderReadOnlyProblem(Folder folder, Path path, boolean bl) {
        Reject.ifNull(path, "Path");
        this.path = path;
        this.revertedOnly = bl;
        this.folder = folder;
    }

    @Override
    public String getDescription() {
        if (this.revertedOnly) {
            return Translation.get("folder_problem.read_only_folder_reverted", this.path.getFileName().toString());
        }
        return Translation.get("folder_problem.read_only_folder", this.path.getFileName().toString());
    }

    @Override
    public String getWikiLinkKey() {
        return null;
    }

    @Override
    public Folder getFolder(Controller controller) {
        return this.folder;
    }

    @Override
    public Runnable resolution(Controller controller) {
        return new Runnable(){

            @Override
            public void run() {
                PathUtils.openFileIfExists(FolderReadOnlyProblem.this.path.getParent());
                FolderReadOnlyProblem.this.folder.removeProblem(FolderReadOnlyProblem.this);
            }
        };
    }

    @Override
    public String getResolutionDescription() {
        return Translation.get("folder_problem.read_only_folder_reverted.resolution_description");
    }
}

